/*
 * Decompiled with CFR 0.152.
 */
package jsdaix.processor.xim_aim.post;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import jsdai.SApplication_context_schema.CApplication_context;
import jsdai.SAssociative_draughting_elements_mim.CDraughting_model_item_association;
import jsdai.SAssociative_draughting_elements_mim.EDraughting_model_item_association;
import jsdai.SDraughting_element_schema.ADraughting_callout_element;
import jsdai.SDraughting_element_schema.CDraughting_callout;
import jsdai.SDraughting_element_schema.EDimension_curve;
import jsdai.SDraughting_element_schema.EDimension_curve_directed_callout;
import jsdai.SDraughting_element_schema.EDraughting_callout;
import jsdai.SDraughting_element_schema.ELeader_curve;
import jsdai.SDraughting_element_schema.ELeader_directed_callout;
import jsdai.SDraughting_element_schema.EProjection_curve;
import jsdai.SDraughting_element_schema.EProjection_directed_callout;
import jsdai.SFabrication_technology_xim.EStratum_technology_occurrence_armx;
import jsdai.SGeometric_tolerance_xim.EGeometric_tolerance_armx;
import jsdai.SLksoft_extensions_xim.EIgnorable_xim;
import jsdai.SPhysical_unit_design_view_xim.AAssembly_component_armx;
import jsdai.SPhysical_unit_design_view_xim.EAssembly_component_armx;
import jsdai.SProduct_definition_schema.CProduct_related_product_category;
import jsdai.SProperty_assignment_xim.EApplied_independent_property;
import jsdai.dictionary.AEntity_or_view_definition;
import jsdai.dictionary.EEntity_definition;
import jsdai.dictionary.ESchema_definition;
import jsdai.lang.AEntity;
import jsdai.lang.ASchemaInstance;
import jsdai.lang.ASdaiModel;
import jsdai.lang.Aggregate;
import jsdai.lang.EEntity;
import jsdai.lang.SchemaInstance;
import jsdai.lang.SdaiContext;
import jsdai.lang.SdaiException;
import jsdai.lang.SdaiIterator;
import jsdai.lang.SdaiModel;
import jsdai.lang.SdaiRepository;
import jsdai.lang.SdaiSession;
import jsdai.libutil.CxAP210ARMUtilities;
import jsdai.libutil.EMappedXIMEntity;
import jsdai.libutil.XimEntityStandalone;
import jsdai.util.LangUtils;

public class Main {
    public static void export(SchemaInstance schemaInstance, SdaiContext context) throws SdaiException {
        ASdaiModel allIncludedModels = new ASdaiModel();
        Main.gatherNestedSchemaModels(schemaInstance, allIncludedModels, new HashSet());
        ArrayList allXimEntities = Main.firstRun(context, allIncludedModels, null);
        Main.secondRun(context, allIncludedModels, null);
        Main.thirdRun(context, null, allXimEntities);
    }

    private static void gatherNestedSchemaModels(SchemaInstance schemaInstance, ASdaiModel domain, HashSet processedSchemas) throws SdaiException {
        if (processedSchemas.contains(schemaInstance)) {
            return;
        }
        processedSchemas.add(schemaInstance);
        ASdaiModel schemaModels = schemaInstance.getAssociatedModels();
        SdaiIterator itModels = schemaModels.createIterator();
        while (itModels.next()) {
            SdaiModel model = (SdaiModel)schemaModels.getCurrentMemberObject(itModels);
            if (!domain.isMember(model)) {
                domain.addUnordered((Object)model, null);
            }
            if (model.getName().equalsIgnoreCase(schemaInstance.getName())) continue;
            ASchemaInstance schemaInstances = model.getAssociatedWith();
            SdaiIterator itShemas = schemaInstances.createIterator();
            while (itShemas.next()) {
                SchemaInstance modelSchema = schemaInstances.getCurrentMember(itShemas);
                if (!modelSchema.getName().equalsIgnoreCase(model.getName())) continue;
                Main.gatherNestedSchemaModels(modelSchema, domain, processedSchemas);
            }
        }
    }

    public static void main(String[] s) throws SdaiException {
        long start = System.currentTimeMillis();
        System.out.println(" Start conversion ");
        Main m = new Main();
        System.out.println(" ... ");
        m.createANDexport(s);
        System.out.println(" Successfully finished ");
        System.out.println(" Total conversion time " + (System.currentTimeMillis() - start) / 1000L + " seconds ");
    }

    private void createANDexport(String[] s) throws SdaiException {
        if (s.length < 3) {
            System.err.println(" utility usage: java jsdaix.processor.xim_aim.post.Main fileNameXIM fileNameAIM schemaNameAIM ");
            return;
        }
        String fileName = s[0];
        String stepFileName = s[1];
        String schemaName = s[2];
        SdaiSession session = SdaiSession.openSession();
        session.startTransactionReadWriteAccess();
        SdaiRepository currentRepository = session.importClearTextEncoding("", (Object)fileName, null);
        ASdaiModel allModels = currentRepository.getModels();
        ASdaiModel dataDomain = new ASdaiModel();
        SdaiModel modelAP210ARMExtended = null;
        int count = allModels.getMemberCount();
        for (int index = 1; index <= count; ++index) {
            SdaiModel model = allModels.getByIndex(index);
            dataDomain.addByIndex(index, (Object)model, null);
            modelAP210ARMExtended = model;
        }
        SdaiContext context = new SdaiContext(dataDomain.getByIndex(1).getUnderlyingSchema(), dataDomain, dataDomain.getByIndex(1));
        session.setSdaiContext(context);
        context.mappedWorkingModel = modelAP210ARMExtended;
        this.export(currentRepository, dataDomain, stepFileName, schemaName, session);
    }

    private static void healData(SdaiContext context, ASdaiModel allIncludedModels) throws SdaiException {
        AEntity dmias = allIncludedModels.getInstances((EEntity_definition)CDraughting_model_item_association.definition);
        int count = dmias.getMemberCount();
        for (int i = 1; i <= count; ++i) {
            EEntity ee;
            EDraughting_model_item_association edmia = (EDraughting_model_item_association)dmias.getByIndexEntity(i);
            if (!edmia.testDefinition(null) || !((ee = edmia.getDefinition(null)) instanceof EGeometric_tolerance_armx)) continue;
            EGeometric_tolerance_armx egta = (EGeometric_tolerance_armx)ee;
            EEntity appliedTo = egta.getApplied_to(null);
            edmia.setDefinition(null, appliedTo);
        }
        Main.healCallouts(context, allIncludedModels);
    }

    private static void healCallouts(SdaiContext context, ASdaiModel allIncludedModels) throws SdaiException {
        AEntity callouts = allIncludedModels.getInstances((EEntity_definition)CDraughting_callout.definition);
        ESchema_definition schema = allIncludedModels.getByIndex(1).getUnderlyingSchema();
        String leaderName = "leader_directed_callout";
        int count = callouts.getMemberCount();
        block0: for (int i = 1; i <= count; ++i) {
            EDraughting_callout edc = (EDraughting_callout)callouts.getByIndexEntity(i);
            if (!edc.testContents(null)) continue;
            ADraughting_callout_element adce = edc.getContents(null);
            int countE = adce.getMemberCount();
            for (int j = 1; j <= countE; ++j) {
                EEntity ee = adce.getByIndex(j);
                if (!(ee instanceof ELeader_curve)) continue;
                if (edc instanceof ELeader_directed_callout) continue block0;
                Main.createComplexIfPossible(context, schema, edc, "leader_directed_callout");
                continue block0;
            }
        }
        String projectionName = "projection_directed_callout";
        int count2 = callouts.getMemberCount();
        block2: for (int i = 1; i <= count2; ++i) {
            EDraughting_callout edc = (EDraughting_callout)callouts.getByIndexEntity(i);
            if (!edc.testContents(null)) continue;
            ADraughting_callout_element adce = edc.getContents(null);
            int countE = adce.getMemberCount();
            for (int j = 1; j <= countE; ++j) {
                EEntity ee = adce.getByIndex(j);
                if (!(ee instanceof EProjection_curve)) continue;
                if (edc instanceof EProjection_directed_callout) continue block2;
                Main.createComplexIfPossible(context, schema, edc, "projection_directed_callout");
                continue block2;
            }
        }
        String dimensionName = "dimension_directed_callout";
        int count3 = callouts.getMemberCount();
        block4: for (int i = 1; i <= count3; ++i) {
            EDraughting_callout edc = (EDraughting_callout)callouts.getByIndexEntity(i);
            if (!edc.testContents(null)) continue;
            ADraughting_callout_element adce = edc.getContents(null);
            int countE = adce.getMemberCount();
            for (int j = 1; j <= countE; ++j) {
                EEntity ee = adce.getByIndex(j);
                if (!(ee instanceof EDimension_curve)) continue;
                if (edc instanceof EDimension_curve_directed_callout) continue block4;
                Main.createComplexIfPossible(context, schema, edc, "dimension_directed_callout");
                continue block4;
            }
        }
    }

    private static void createComplexIfPossible(SdaiContext context, ESchema_definition schema, EDraughting_callout edc, String leaderName) {
        try {
            String name;
            EEntity_definition type = edc.getInstanceType();
            EEntity_definition newComplex = null;
            if (type.getComplex(null)) {
                AEntity_or_view_definition complexLeaves = type.getGeneric_supertypes(null);
                TreeSet<String> complexNames = new TreeSet<String>();
                complexNames.add(leaderName);
                SdaiIterator c = complexLeaves.createIterator();
                while (c.next()) {
                    EEntity_definition complexLeaf = (EEntity_definition)complexLeaves.getCurrentMember(c);
                    complexNames.add(complexLeaf.getName(null));
                }
                StringBuffer complexNameBuffer = new StringBuffer();
                Iterator c2 = complexNames.iterator();
                while (c2.hasNext()) {
                    complexNameBuffer.append(c2.next()).append('+');
                }
                complexNameBuffer.setLength(complexNameBuffer.length() - 1);
                name = complexNameBuffer.toString();
            } else {
                name = type.getName(null);
                name = name.compareTo(leaderName) > 0 ? leaderName + "+" + name : name + "+" + leaderName;
            }
            newComplex = LangUtils.findEntityDefinition((String)name, (ESchema_definition)schema);
            if (newComplex == null) {
                Main.sessionLog(context, "Missing Complex " + name);
            } else {
                edc.findEntityInstanceSdaiModel().substituteInstance((EEntity)edc, newComplex);
            }
        }
        catch (SdaiException e) {
            Main.sessionLog(context, "Failed to create complex for " + edc + " with " + leaderName);
            e.printStackTrace();
        }
    }

    private static ArrayList firstRun(SdaiContext context, ASdaiModel allIncludedModels, SdaiModel modelAIM) throws SdaiException {
        int index;
        if (modelAIM == null) {
            modelAIM = context.domain.getByIndex(2);
        }
        Main.healData(context, allIncludedModels);
        Object[] allOriginalInstances = LangUtils.aggregateToArray((Aggregate)allIncludedModels.getInstances());
        ArrayList allInstancesBasedOnXIM = new ArrayList();
        AEntity categories = allIncludedModels.getExactInstances((EEntity_definition)CProduct_related_product_category.definition);
        while (categories.getMemberCount() > 0) {
            EEntity category = categories.getByIndexEntity(1);
            modelAIM.substituteInstance(category);
        }
        AEntity contexts = allIncludedModels.getExactInstances((EEntity_definition)CApplication_context.definition);
        while (contexts.getMemberCount() > 0) {
            EEntity ee = contexts.getByIndexEntity(1);
            modelAIM.substituteInstance(ee);
        }
        AAssembly_component_armx aac = new AAssembly_component_armx();
        for (index = 0; index < allOriginalInstances.length; ++index) {
            EEntity instanceExtended = (EEntity)allOriginalInstances[index];
            EEntity_definition oldType = instanceExtended.getInstanceType();
            SdaiModel underlyingModel = oldType.findEntityInstanceSdaiModel();
            String schemaName = underlyingModel.getDefinedSchema().getName(null);
            if (instanceExtended instanceof EAssembly_component_armx) {
                aac.addUnordered(instanceExtended);
                continue;
            }
            if (instanceExtended instanceof EMappedXIMEntity) {
                EApplied_independent_property eaip;
                Main.createAimData(context, allInstancesBasedOnXIM, instanceExtended);
                if (!(instanceExtended instanceof EApplied_independent_property) || !(eaip = (EApplied_independent_property)instanceExtended).testDefinition(null) || !(eaip.getDefinition(null) instanceof EStratum_technology_occurrence_armx)) continue;
                eaip.unsetDefinition(null);
                continue;
            }
            if (!schemaName.substring(schemaName.length() - 3, schemaName.length()).equalsIgnoreCase("XIM")) continue;
            if (instanceExtended instanceof EIgnorable_xim) {
                instanceExtended.deleteApplicationInstance();
                continue;
            }
            Main.sessionLog(context, "Missing Cx " + instanceExtended.getClass() + " within " + schemaName);
        }
        int count = aac.getMemberCount();
        for (index = 1; index <= count; ++index) {
            EAssembly_component_armx instanceExtended = aac.getByIndex(index);
            Main.createAimData(context, allInstancesBasedOnXIM, (EEntity)instanceExtended);
        }
        return allInstancesBasedOnXIM;
    }

    private static void createAimData(SdaiContext context, ArrayList allInstancesBasedOnXIM, EEntity instanceExtended) {
        EMappedXIMEntity instance = (EMappedXIMEntity)instanceExtended;
        try {
            instance.createAimData(context);
        }
        catch (SdaiException ex) {
            String log = "Problems with createAimData for " + instance;
            Main.sessionLog(context, log);
            Main.exceptionWraper(context, (Exception)((Object)ex));
        }
        if (instanceExtended.isValid()) {
            allInstancesBasedOnXIM.add(instanceExtended);
        }
    }

    private static void secondRun(SdaiContext context, ASdaiModel allIncludedModels, SdaiModel modelAIM) throws SdaiException {
        if (modelAIM == null) {
            modelAIM = context.domain.getByIndex(2);
        }
        Object[] allOriginalInstances = LangUtils.aggregateToArray((Aggregate)allIncludedModels.getInstances());
        for (int index = 0; index < allOriginalInstances.length; ++index) {
            EEntity instanceExtended = (EEntity)allOriginalInstances[index];
            EEntity_definition oldType = instanceExtended.getInstanceType();
            if (instanceExtended instanceof EMappedXIMEntity) continue;
            try {
                instanceExtended = modelAIM.substituteInstance(instanceExtended);
                continue;
            }
            catch (SdaiException ex) {
                String log = "Problems with substituting instances:  oldType " + oldType + " to new type " + instanceExtended;
                Main.sessionLog(context, log);
            }
        }
    }

    private static void thirdRun(SdaiContext context, SdaiModel modelAIM, ArrayList allInstancesBasedOnXIM) throws SdaiException {
        Iterator iter = allInstancesBasedOnXIM.iterator();
        while (iter.hasNext()) {
            EEntity instance = (EEntity)iter.next();
            EMappedXIMEntity instanceExtended = (EMappedXIMEntity)instance;
            if (!instanceExtended.isValid()) continue;
            EEntity_definition newType = (EEntity_definition)instanceExtended.getTemp((Object)"AIM");
            try {
                boolean successfulCopy;
                EEntity temporaryInstance = null;
                if (instanceExtended instanceof XimEntityStandalone) {
                    XimEntityStandalone ximInstance = (XimEntityStandalone)instanceExtended;
                    temporaryInstance = ximInstance.getAimInstance(context);
                    ximInstance.unsetAimInstance(context);
                }
                AEntity instances = new AEntity();
                instance.findEntityInstanceUsers(context.domain, instances);
                EEntity substitute = modelAIM.substituteInstance((EEntity)instanceExtended, newType);
                if (temporaryInstance == null || !(successfulCopy = LangUtils.copyAttributes((EEntity)temporaryInstance, (EEntity)substitute))) continue;
                temporaryInstance.deleteApplicationInstance();
            }
            catch (Exception ex) {
                Main.exceptionWraper(context, ex);
                String log = instanceExtended + " AIM1 " + newType + " " + instanceExtended.getClass() + " " + instanceExtended.getTemp((Object)"AIM");
                Main.sessionLog(context, log);
                EEntity_definition oldType = instanceExtended.getInstanceType();
                if (!oldType.isSubtypeOf(newType)) {
                    Main.sessionLog(context, "");
                    Main.sessionLog(context, newType + " NOT SUB-AIM " + oldType);
                }
                AEntity result = new AEntity();
                if (!instanceExtended.isValid()) {
                    Main.sessionLog(context, "");
                    continue;
                }
                instanceExtended.findEntityInstanceUsers(context.domain, result);
                for (int i = 1; i <= result.getMemberCount(); ++i) {
                    Main.sessionLog(context, " " + i + " : " + result.getByIndexEntity(i));
                }
                Main.sessionLog(context, "");
            }
        }
        allInstancesBasedOnXIM.clear();
    }

    public void export(SdaiRepository repoXIM, ASdaiModel dataDomain, String schemaName, SdaiSession session) throws SdaiException {
        SdaiContext context;
        SdaiModel modelAIM;
        String modelName;
        int i;
        ASdaiModel domainAIM = new ASdaiModel();
        ESchema_definition schema = session.findSchemaDefinition(schemaName);
        SchemaInstance asi = repoXIM.createSchemaInstance("mim2xim", schema);
        SchemaInstance asiARM = repoXIM.createSchemaInstance("mim2xim-mim", schema);
        HashMap<SdaiModel, SdaiModel> ximToAim = new HashMap<SdaiModel, SdaiModel>();
        HashMap<SdaiModel, ArrayList> ximEntitiesToAim = new HashMap<SdaiModel, ArrayList>();
        ArrayList<SdaiModel> modelsXim = new ArrayList<SdaiModel>();
        int count = dataDomain.getMemberCount();
        for (i = 1; i <= count; ++i) {
            modelsXim.add(dataDomain.getByIndex(i));
        }
        for (i = 0; i < modelsXim.size(); ++i) {
            SdaiModel modelXIM = (SdaiModel)modelsXim.get(i);
            modelName = modelXIM.getName();
            modelAIM = repoXIM.createSdaiModel(modelName + "-MIM", schema);
            ximToAim.put(modelXIM, modelAIM);
            domainAIM.addByIndex(i + 1, (Object)modelAIM, null);
            asi.addSdaiModel(modelAIM);
            context = new SdaiContext(modelAIM.getUnderlyingSchema(), domainAIM, modelAIM);
            modelAIM.startReadWriteAccess();
            ASdaiModel domainARM = new ASdaiModel();
            domainARM.addByIndex(1, (Object)modelXIM, null);
            asiARM.addSdaiModel(modelXIM);
            ximEntitiesToAim.put(modelXIM, Main.firstRun(context, domainARM, modelAIM));
            Main.secondRun(context, domainARM, modelAIM);
        }
        for (i = 0; i < modelsXim.size(); ++i) {
            SdaiModel modelXIM = (SdaiModel)modelsXim.get(i);
            modelName = modelXIM.getName();
            modelAIM = (SdaiModel)ximToAim.get(modelXIM);
            context = new SdaiContext(modelAIM.getUnderlyingSchema(), domainAIM, modelAIM);
            Main.thirdRun(context, modelAIM, (ArrayList)ximEntitiesToAim.get(modelXIM));
            ASchemaInstance associatedSchemas = modelXIM.getAssociatedWith();
            SdaiIterator it = associatedSchemas.createIterator();
            while (it.next()) {
                SchemaInstance schemaInstance = associatedSchemas.getCurrentMember(it);
                schemaInstance.setNativeSchema(schema);
                schemaInstance.addSdaiModel(modelAIM);
            }
            modelXIM.deleteSdaiModel();
            modelAIM.renameSdaiModel(modelName);
        }
        asi.delete();
        asiARM.delete();
        CxAP210ARMUtilities.mostlyUsedInstances.clear();
    }

    public void export(SdaiRepository repoXIM, ASdaiModel dataDomain, String stepFileName, String schemaName, SdaiSession session) throws SdaiException {
        this.export(repoXIM, dataDomain, schemaName, session);
        repoXIM.exportClearTextEncoding(stepFileName, stepFileName);
    }

    private static void sessionLog(SdaiContext context, String log) {
        try {
            SdaiSession session = context.working_model.getRepository().getSession();
            session.printlnSession(log);
        }
        catch (SdaiException ex2) {
            System.err.println("Problems with logging in session ");
            System.err.println(log);
            ex2.printStackTrace();
        }
    }

    private static void exceptionWraper(SdaiContext context, Exception ex) {
        try {
            SdaiSession session = context.working_model.getRepository().getSession();
            session.printlnSession("  ");
            session.printlnSession("  " + ex.toString());
            StackTraceElement[] stes = ex.getStackTrace();
            for (int i = 0; i < stes.length; ++i) {
                session.printlnSession("  " + stes[i].toString());
            }
            session.printlnSession("  ");
        }
        catch (Exception ex2) {
            System.err.println("Problems with logging in session ");
            ex2.printStackTrace();
            ex.printStackTrace();
        }
    }
}

