/*
 * Decompiled with CFR 0.152.
 */
package jsdaix.processor.xim_aim.pre;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import jsdai.SAction_schema.CAction_method_relationship;
import jsdai.SApplication_context_schema.CProduct_context;
import jsdai.SApproval_schema.CApproval_role;
import jsdai.SBasic_attribute_schema.CDescription_attribute;
import jsdai.SBasic_attribute_schema.CName_attribute;
import jsdai.SBasic_attribute_schema.CObject_role;
import jsdai.SBasic_attribute_schema.CRole_association;
import jsdai.SDocument_assignment_mim.CDocument_product_equivalence;
import jsdai.SDocument_schema.CDocument;
import jsdai.SDocument_schema.CDocument_type;
import jsdai.SGeometric_tolerance_xim.AGeometric_tolerance_armx;
import jsdai.SGeometric_tolerance_xim.CGeometric_tolerance_armx;
import jsdai.SGeometric_tolerance_xim.EGeometric_tolerance_armx;
import jsdai.SGroup_mim.CApplied_group_assignment;
import jsdai.SIdentification_assignment_mim.CApplied_identification_assignment;
import jsdai.SManagement_resources_schema.CIdentification_role;
import jsdai.SManagement_resources_schema.COrganizational_project_role;
import jsdai.SManagement_resources_schema.CPosition_in_organization_role;
import jsdai.SMaterial_property_definition_schema.CProperty_definition_relationship;
import jsdai.SMethod_definition_schema.CSequential_method;
import jsdai.SMixed_complex_types.CGlobal_uncertainty_assigned_context;
import jsdai.SProduct_definition_schema.CProduct_definition_context_association;
import jsdai.SProduct_definition_schema.CProduct_definition_context_role;
import jsdai.SProduct_definition_schema.CProduct_definition_relationship;
import jsdai.SProduct_property_definition_schema.CGeneral_property_association;
import jsdai.SProduct_property_definition_schema.CProperty_definition;
import jsdai.SProduct_property_representation_schema.CProperty_definition_representation;
import jsdai.SProduct_property_representation_schema.CShape_definition_representation;
import jsdai.SProduct_structure_schema.CProduct_definition_usage;
import jsdai.SQualified_measure_schema.CType_qualifier;
import jsdai.SRepresentation_schema.CGlobal_uncertainty_assigned_context;
import jsdai.SRepresentation_schema.CItem_defined_transformation;
import jsdai.SRepresentation_schema.CParametric_representation_context;
import jsdai.SRepresentation_schema.CRepresentation_item;
import jsdai.SRequirement_assignment_mim.CAssigned_requirement;
import jsdai.SRequirement_assignment_mim.CRequirement_assigned_object;
import jsdai.SShape_aspect_definition_schema.CShape_aspect_deriving_relationship;
import jsdai.SShape_aspect_definition_schema.CShape_representation_with_parameters;
import jsdai.SShape_dimension_schema.CDimensional_characteristic_representation;
import jsdai.SShape_dimension_schema.CShape_dimension_representation;
import jsdai.SShape_parameters_mim.CKeepout_design_object_category;
import jsdai.SShape_tolerance_schema.AGeometric_tolerance_with_modifiers;
import jsdai.SShape_tolerance_schema.CGeometric_tolerance_relationship;
import jsdai.SShape_tolerance_schema.CGeometric_tolerance_with_modifiers;
import jsdai.SShape_tolerance_schema.CTolerance_zone_form;
import jsdai.SShape_tolerance_schema.EGeometric_tolerance_with_modifiers;
import jsdai.dictionary.EEntity_definition;
import jsdai.lang.ASdaiModel;
import jsdai.lang.A_enumeration;
import jsdai.lang.MappingContext;
import jsdai.lang.SchemaInstance;
import jsdai.lang.SdaiContext;
import jsdai.lang.SdaiException;
import jsdai.lang.SdaiIterator;
import jsdai.lang.SdaiModel;
import jsdai.lang.SdaiRepository;
import jsdai.lang.SdaiSession;
import jsdai.lang.SdaiTransaction;
import jsdai.util.UtilMonitor;
import jsdaix.processor.xim_aim.pre.AutomaticXimPopulationCreator;
import jsdaix.processor.xim_aim.pre.manual_aim_repair.AP203SpecificRepair;
import jsdaix.processor.xim_aim.pre.manual_aim_repair.Ap203ProductCategoryRepair;
import jsdaix.processor.xim_aim.pre.manual_aim_repair.DocumentRepair;
import jsdaix.processor.xim_aim.pre.manual_aim_repair.Item_defined_transformationRepair;
import jsdaix.processor.xim_aim.pre.manual_aim_repair.ProductCategoryFlattener;
import jsdaix.processor.xim_aim.pre.manual_aim_repair.RolesRepair;
import jsdaix.processor.xim_aim.pre.manual_aim_repair.StylingModelRepair;
import jsdaix.processor.xim_aim.pre.manual_aim_repair.TargetDiameterFixer;
import jsdaix.processor.xim_aim.pre.manual_aim_repair.ValueRangeFixer;
import jsdaix.processor.xim_aim.pre.manual_arm_repair.AIMGarbageCleaner;
import jsdaix.processor.xim_aim.pre.manual_arm_repair.AP210SpecificGarbageCleaner;
import jsdaix.processor.xim_aim.pre.manual_arm_repair.AssemblyRepair;
import jsdaix.processor.xim_aim.pre.manual_arm_repair.Closed_curveFixer;
import jsdaix.processor.xim_aim.pre.manual_arm_repair.DatumTargetFixer;
import jsdaix.processor.xim_aim.pre.manual_arm_repair.DefinitionsRepair;
import jsdaix.processor.xim_aim.pre.manual_arm_repair.FakedMappingCleaner;
import jsdaix.processor.xim_aim.pre.manual_arm_repair.GDTRepair;
import jsdaix.processor.xim_aim.pre.manual_arm_repair.IncorrectReuseOfContextRepair;
import jsdaix.processor.xim_aim.pre.manual_arm_repair.MRIDowngrader;
import jsdaix.processor.xim_aim.pre.manual_arm_repair.PartsRepair;
import jsdaix.processor.xim_aim.pre.manual_arm_repair.RepresentationRelationshipRepair;
import jsdaix.processor.xim_aim.pre.manual_arm_repair.ShapeAspectRelationshipCleaner;

public class Importer {
    static PrintStream pout;
    static PrintStream perr;
    static BufferedOutputStream bout;
    static BufferedOutputStream berr;
    static FileOutputStream fout;
    static FileOutputStream ferr;
    static boolean flag_from_initAsRunnable;
    protected PrintStream outputLog = null;
    public static final String messagePrefix = "MIM2XIM Healing:";
    SdaiSession session;
    private final EEntity_definition[] typesToRemove = new EEntity_definition[]{CProduct_definition_relationship.definition, CProperty_definition_representation.definition, CProperty_definition_relationship.definition, CProperty_definition.definition, CRepresentation_item.definition, CProduct_definition_context_role.definition, CAssigned_requirement.definition, CRequirement_assigned_object.definition, CApplied_group_assignment.definition, CParametric_representation_context.definition, CGlobal_uncertainty_assigned_context.global_unit_assigned_context.parametric_representation_context.definition, CGlobal_uncertainty_assigned_context.parametric_representation_context.definition, CProduct_definition_usage.definition, CProduct_definition_context_association.definition, CProduct_context.definition, COrganizational_project_role.definition, CAction_method_relationship.definition, CDocument_type.definition, CDocument.definition, CType_qualifier.definition, CDocument_product_equivalence.definition, CItem_defined_transformation.definition, CRole_association.definition, CObject_role.definition, CApproval_role.definition, CGeneral_property_association.definition, CDescription_attribute.definition, CName_attribute.definition, CKeepout_design_object_category.definition, CSequential_method.definition, CPosition_in_organization_role.definition, CShape_definition_representation.definition, CShape_aspect_deriving_relationship.definition, CDimensional_characteristic_representation.definition, CShape_dimension_representation.definition, CTolerance_zone_form.definition, CGeometric_tolerance_relationship.definition, CIdentification_role.definition, CShape_representation_with_parameters.definition, CApplied_identification_assignment.definition};

    public void logMessage(String message) throws SdaiException {
        if (flag_from_initAsRunnable) {
            System.out.println(message);
        } else {
            this.session.printlnSession(message);
        }
    }

    public void errorMessage(String message) throws SdaiException {
        if (flag_from_initAsRunnable) {
            System.err.println(messagePrefix + message);
        } else {
            this.session.printlnSession(messagePrefix + message);
        }
    }

    public void setOutputLog(PrintStream stream) {
        this.outputLog = stream;
    }

    public void setLocation(String location) {
    }

    public void output(String msg) {
        if (this.outputLog != null) {
            this.outputLog.println(msg);
        }
    }

    public static void main(String[] args) throws SdaiException {
        long time = System.currentTimeMillis();
        String stepFileName = args[0];
        SdaiSession session = SdaiSession.openSession();
        Importer importer = new Importer();
        SdaiTransaction transaction = importer.startTransactionReadWriteAccess(session);
        SdaiRepository repo = session.importClearTextEncoding("", (Object)stepFileName, null);
        long time2 = System.currentTimeMillis();
        importer.runImport(repo);
        importer.errorMessage(" Importing time is " + (time2 - time) / 1000L + " seconds");
        importer.errorMessage(" Time after processing is " + (System.currentTimeMillis() - time) / 1000L + " seconds");
        transaction.commit();
        repo.exportClearTextEncoding(stepFileName + "_");
        importer.errorMessage(" Overall conversion time is " + (System.currentTimeMillis() - time) / 1000L + " seconds");
    }

    public void runImport(SdaiRepository inputRepo) throws SdaiException {
        if (inputRepo == null) {
            throw new SdaiException(500, (Object)"No source data found!");
        }
        this.runImport(inputRepo.getModels());
    }

    public void runImport(SchemaInstance schema) throws SdaiException {
        if (schema == null) {
            throw new SdaiException(500, (Object)"No source data found!");
        }
        this.runImport(schema.getAssociatedModels());
    }

    public void runImport(ASdaiModel models) throws SdaiException {
        if (models == null || models.getMemberCount() == 0) {
            throw new SdaiException(500, (Object)"No source data found!");
        }
        SdaiModel model = models.getByIndex(1);
        SdaiContext context = new SdaiContext(model);
        context.working_modelAggr = models;
        context.working_model = null;
        this.session = model.getRepository().getSession();
        this.session.setSdaiContext(context);
        DocumentRepair.run(models, this);
        AP203SpecificRepair.run(models, this);
        RolesRepair.run(models, this);
        ProductCategoryFlattener.run(models, this);
        Ap203ProductCategoryRepair.run(models, this);
        Item_defined_transformationRepair.run(models, this);
        ValueRangeFixer.run(models, this);
        StylingModelRepair.run(models, this);
        TargetDiameterFixer.run(models, this);
        Map instances2Values = this.preProcessModifiers(models);
        AutomaticXimPopulationCreator ximPopulationCreator = new AutomaticXimPopulationCreator(context, this);
        try {
            SdaiSession.convertMapping((MappingContext)ximPopulationCreator.getMappingContext());
        }
        catch (SdaiException ex) {
            ex.printStackTrace();
            this.logMessage("--------");
            this.logMessage(ex.getMessage());
            this.logMessage("--------");
        }
        catch (Throwable tt) {
            tt.printStackTrace();
            throw (SdaiException)new SdaiException(1000, (Object)tt.getMessage()).initCause(tt);
        }
        this.postProcessModifiers(models, instances2Values);
        GDTRepair.run(context, models, this);
        FakedMappingCleaner.run(models, ximPopulationCreator, this);
        AP210SpecificGarbageCleaner.run(models, this);
        AIMGarbageCleaner.run(models, this.typesToRemove, this);
        MRIDowngrader.run(models, this);
        Closed_curveFixer.run(models, this);
        ShapeAspectRelationshipCleaner.run(models, this);
        PartsRepair.run(models, this);
        DefinitionsRepair.run(models, this);
        AssemblyRepair.run(models, this);
        RepresentationRelationshipRepair.run(models, this);
        IncorrectReuseOfContextRepair.run(models, this);
        StylingModelRepair.runAfterMapping(models, this);
        DatumTargetFixer.run(models, this);
    }

    private void postProcessModifiers(ASdaiModel models, Map instances2Values) throws SdaiException {
        AGeometric_tolerance_armx agt = (AGeometric_tolerance_armx)models.getInstances((EEntity_definition)CGeometric_tolerance_armx.definition);
        SdaiIterator j = agt.createIterator();
        while (j.next()) {
            EGeometric_tolerance_armx egt = agt.getCurrentMember(j);
            int[] values = (int[])instances2Values.get(egt.getPersistentLabel());
            if (values == null) continue;
            A_enumeration enums = egt.createModification_new(null);
            for (int i = 0; i < values.length; ++i) {
                enums.addUnordered(values[i]);
            }
        }
    }

    private Map preProcessModifiers(ASdaiModel models) throws SdaiException {
        HashMap<String, int[]> instances2Values = new HashMap<String, int[]>();
        AGeometric_tolerance_with_modifiers agtwm = (AGeometric_tolerance_with_modifiers)models.getInstances((EEntity_definition)CGeometric_tolerance_with_modifiers.definition);
        SdaiIterator j = agtwm.createIterator();
        while (j.next()) {
            EGeometric_tolerance_with_modifiers egtwm = agtwm.getCurrentMember(j);
            A_enumeration ae = egtwm.getModifiers(null);
            int[] values = new int[ae.getMemberCount()];
            for (int i = 1; i <= values.length; ++i) {
                values[i - 1] = ae.getByIndex(i);
            }
            instances2Values.put(egtwm.getPersistentLabel(), values);
        }
        return instances2Values;
    }

    private SdaiTransaction startTransactionReadWriteAccess(SdaiSession session) throws SdaiException {
        if (session.testActiveTransaction()) {
            SdaiTransaction transaction = session.getActiveTransaction();
            if (transaction.getMode() == 1) {
                transaction.endTransactionAccessAbort();
                transaction = session.startTransactionReadWriteAccess();
            }
            return transaction;
        }
        return session.startTransactionReadWriteAccess();
    }

    public static Runnable initAsRunnable(String sdaireposDirectory, final String[] args, UtilMonitor monitor) throws SdaiException {
        Properties jsdaiProperties = new Properties();
        jsdaiProperties.setProperty("repositories", sdaireposDirectory);
        jsdaiProperties.setProperty("mapping.schema.IDA_STEP_SCHEMA_XIM", "IDA_STEP_SCHEMA_XIM_MAPPING_DATA");
        jsdaiProperties.setProperty("mapping.schema.IDA_STEP_AIM_SCHEMA", "IDA_STEP_SCHEMA_XIM_MAPPING_DATA");
        jsdaiProperties.setProperty("mapping.schema.AUTOMOTIVE_DESIGN", "IDA_STEP_SCHEMA_XIM_MAPPING_DATA");
        jsdaiProperties.setProperty("jsdai.SIda_step_schema_xim", "AC*;AI*;AP*;ASS*;AU*;B*;C*;D*;E*;F*;G*;H*;IDA_STEP_AIM*;ISO*;IN*;J*;K*;L*;M*;N*;O*;P*;Q*;R*;S*;T*;U*;V*;W*;X*;Y*;Z*;");
        SdaiSession.setSessionProperties((Properties)jsdaiProperties);
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    flag_from_initAsRunnable = true;
                    fout = new FileOutputStream(args[0] + "_log_conversion");
                    bout = new BufferedOutputStream(fout);
                    pout = new PrintStream(bout);
                    System.setOut(pout);
                    ferr = new FileOutputStream(args[0] + "_log_conversion_err");
                    berr = new BufferedOutputStream(ferr);
                    perr = new PrintStream(berr);
                    System.setErr(perr);
                    System.out.println("Conversion: invoking main: " + args);
                    Importer.main(args);
                    System.out.println("Conversion: main ended ");
                }
                catch (Exception eee) {
                    System.out.println("Conversion: exception occured: " + eee);
                    eee.printStackTrace();
                }
                finally {
                    flag_from_initAsRunnable = false;
                    pout.flush();
                    pout.close();
                    perr.flush();
                    perr.close();
                }
            }
        };
    }

    static {
        flag_from_initAsRunnable = false;
    }
}

