/*
 * Decompiled with CFR 0.152.
 */
package jsdaix.processor.xim_aim.pre.manual_aim_repair;

import java.util.Arrays;
import java.util.List;
import jsdai.SProduct_definition_schema.AProduct;
import jsdai.SProduct_definition_schema.AProduct_related_product_category;
import jsdai.SProduct_definition_schema.CProduct;
import jsdai.SProduct_definition_schema.CProduct_related_product_category;
import jsdai.SProduct_definition_schema.EProduct;
import jsdai.SProduct_definition_schema.EProduct_related_product_category;
import jsdai.dictionary.EEntity_definition;
import jsdai.lang.AEntity;
import jsdai.lang.ASdaiModel;
import jsdai.lang.EEntity;
import jsdai.lang.SdaiException;
import jsdai.lang.SdaiIterator;
import jsdai.lang.SdaiModel;
import jsdaix.processor.xim_aim.pre.Importer;

public final class Ap203ProductCategoryRepair {
    private static final String AP203_AIM_SCHEMA_NAME = "config_control_design";
    private static final String PART_CATEGORY_NAME = "part";
    private static final List AP203_PART_CATEGORIES = Arrays.asList("assembly", "detail", "customer_furnished_equipment", "inseparable_assembly", "cast", "coined", "drawn", "extruded", "forged", "formed", "machined", "molded", "rolled", "sheared");

    private Ap203ProductCategoryRepair() {
    }

    public static void run(ASdaiModel models, Importer importer) throws SdaiException {
        EProduct_related_product_category ePartCategory = null;
        SdaiIterator i = models.createIterator();
        while (i.next()) {
            SdaiModel model = models.getCurrentMember(i);
            if (!model.getOriginalSchemaName().equalsIgnoreCase(AP203_AIM_SCHEMA_NAME)) continue;
            AProduct aProducts = (AProduct)model.getInstances((EEntity_definition)CProduct.definition);
            SdaiIterator j = aProducts.createIterator();
            while (j.next()) {
                EProduct eProduct = aProducts.getCurrentMember(j);
                if (!Ap203ProductCategoryRepair.needsRepair(eProduct, models)) continue;
                if (ePartCategory == null) {
                    ePartCategory = Ap203ProductCategoryRepair.createPartCategory(model, importer);
                }
                ePartCategory.getProducts(null).addUnordered((EEntity)eProduct);
            }
        }
    }

    private static EProduct_related_product_category createPartCategory(SdaiModel model, Importer importer) throws SdaiException {
        EProduct_related_product_category ePartCategory = (EProduct_related_product_category)model.createEntityInstance((EEntity_definition)CProduct_related_product_category.definition);
        ePartCategory.setName(null, PART_CATEGORY_NAME);
        ePartCategory.setDescription(null, "generated");
        ePartCategory.createProducts(null);
        importer.logMessage(" Created new category " + ePartCategory);
        return ePartCategory;
    }

    private static boolean needsRepair(EProduct eProduct, ASdaiModel domain) throws SdaiException {
        AProduct_related_product_category aCategories = new AProduct_related_product_category();
        CProduct_related_product_category.usedinProducts(null, (EProduct)eProduct, (ASdaiModel)domain, (AEntity)aCategories);
        if (aCategories.getMemberCount() == 0) {
            return true;
        }
        boolean hasAp210PartCat = false;
        SdaiIterator i = aCategories.createIterator();
        while (i.next()) {
            EProduct_related_product_category eCategory = aCategories.getCurrentMember(i);
            if (!eCategory.testName(null)) continue;
            String name = eCategory.getName(null);
            if (name.equals(PART_CATEGORY_NAME)) {
                return false;
            }
            if (!AP203_PART_CATEGORIES.contains(name.toLowerCase())) continue;
            hasAp210PartCat = true;
        }
        return hasAp210PartCat;
    }
}

