/*
 * Decompiled with CFR 0.152.
 */
package jsdaix.processor.xim_aim.pre.manual_aim_repair;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import jsdai.SDocument_schema.ADocument;
import jsdai.SDocument_schema.ADocument_representation_type;
import jsdai.SDocument_schema.CDocument;
import jsdai.SDocument_schema.CDocument_representation_type;
import jsdai.SDocument_schema.EDocument;
import jsdai.SDocument_schema.EDocument_representation_type;
import jsdai.SFile_identification_mim.CDocument_file;
import jsdai.SFile_identification_mim.EDocument_file;
import jsdai.dictionary.EEntity_definition;
import jsdai.lang.AEntity;
import jsdai.lang.ASdaiModel;
import jsdai.lang.EEntity;
import jsdai.lang.SdaiException;
import jsdai.lang.SdaiIterator;
import jsdaix.processor.xim_aim.pre.Importer;

public class DocumentRepair {
    private static final String TYPE_PHYSICAL = "physical";
    private static final String TYPE_DIGITAL = "digital";
    private static final Set REQUIRED_TYPES;

    private DocumentRepair() {
    }

    public static void run(ASdaiModel domain, Importer importer) throws SdaiException {
        ADocument aDoc = (ADocument)domain.getInstances((EEntity_definition)CDocument.definition);
        SdaiIterator i = aDoc.createIterator();
        while (i.next()) {
            EDocument eDoc = aDoc.getCurrentMember(i);
            eDoc = DocumentRepair.ensureCorrectEntityType(eDoc, importer);
            DocumentRepair.ensureCorrectRepresentationType(domain, eDoc, importer);
        }
    }

    private static EDocument ensureCorrectEntityType(EDocument eDoc, Importer importer) throws SdaiException {
        if (!(eDoc instanceof EDocument_file)) {
            importer.logMessage(" Change " + eDoc + " to Document_file");
            eDoc = (EDocument)eDoc.findEntityInstanceSdaiModel().substituteInstance((EEntity)eDoc, (EEntity_definition)CDocument_file.definition);
        }
        return eDoc;
    }

    private static void ensureCorrectRepresentationType(ASdaiModel domain, EDocument eDoc, Importer importer) throws SdaiException {
        if (!DocumentRepair.hasAppropriateType(domain, eDoc)) {
            EDocument_representation_type eDrt = (EDocument_representation_type)eDoc.findEntityInstanceSdaiModel().createEntityInstance((EEntity_definition)CDocument_representation_type.definition);
            eDrt.setName(null, TYPE_DIGITAL);
            eDrt.setRepresented_document(null, eDoc);
            importer.logMessage(" Created missing instance " + eDrt);
        }
    }

    private static boolean hasAppropriateType(ASdaiModel models, EDocument eDoc) throws SdaiException {
        ADocument_representation_type aDrt = new ADocument_representation_type();
        CDocument_representation_type.usedinRepresented_document(null, (EDocument)eDoc, (ASdaiModel)models, (AEntity)aDrt);
        SdaiIterator i = aDrt.createIterator();
        while (i.next()) {
            EDocument_representation_type eDrt = aDrt.getCurrentMember(i);
            if (!eDrt.testName(null) || !REQUIRED_TYPES.contains(eDrt.getName(null))) continue;
            return true;
        }
        return false;
    }

    static {
        HashSet<String> requiredTypes = new HashSet<String>();
        requiredTypes.add(TYPE_DIGITAL);
        requiredTypes.add(TYPE_PHYSICAL);
        REQUIRED_TYPES = Collections.unmodifiableSet(requiredTypes);
    }
}

