/*
 * Decompiled with CFR 0.152.
 */
package jsdaix.processor.xim_aim.pre.manual_aim_repair;

import jsdai.SGeometry_schema.EAxis2_placement_2d;
import jsdai.SGeometry_schema.EAxis2_placement_3d;
import jsdai.SGeometry_schema.ECartesian_point;
import jsdai.SGeometry_schema.ECartesian_transformation_operator;
import jsdai.SGeometry_schema.EDirection;
import jsdai.SGeometry_schema.EPlacement;
import jsdai.SRepresentation_schema.AItem_defined_transformation;
import jsdai.SRepresentation_schema.ARepresentation_relationship_with_transformation;
import jsdai.SRepresentation_schema.CItem_defined_transformation;
import jsdai.SRepresentation_schema.CRepresentation_relationship_with_transformation;
import jsdai.SRepresentation_schema.EItem_defined_transformation;
import jsdai.SRepresentation_schema.ERepresentation_relationship_with_transformation;
import jsdai.dictionary.EEntity_definition;
import jsdai.lang.AEntity;
import jsdai.lang.ASdaiModel;
import jsdai.lang.A_double;
import jsdai.lang.EEntity;
import jsdai.lang.SdaiException;
import jsdai.lang.SdaiIterator;
import jsdai.lang.SdaiModel;
import jsdaix.processor.xim_aim.pre.Importer;

public final class Item_defined_transformationRepair {
    private static final float precision = 1.0E-5f;

    private Item_defined_transformationRepair() {
    }

    public static void run(ASdaiModel models, Importer importer) throws SdaiException {
        SdaiIterator i = models.createIterator();
        while (i.next()) {
            SdaiModel model = models.getCurrentMember(i);
            AItem_defined_transformation transformations = (AItem_defined_transformation)model.getInstances((EEntity_definition)CItem_defined_transformation.definition);
            SdaiIterator j = transformations.createIterator();
            while (j.next()) {
                EItem_defined_transformation transformation = transformations.getCurrentMember(j);
                ARepresentation_relationship_with_transformation arrwt = Item_defined_transformationRepair.getItemsToRepair(transformation, models, importer);
                if (arrwt == null) continue;
                ECartesian_transformation_operator cto = Item_defined_transformationRepair.getCTO(transformation, models, importer);
                int rCount = arrwt.getMemberCount();
                for (int r = 1; r <= rCount; ++r) {
                    ERepresentation_relationship_with_transformation errwt = arrwt.getByIndex(r);
                    errwt.setTransformation_operator(null, (EEntity)cto);
                }
            }
        }
    }

    private static ARepresentation_relationship_with_transformation getItemsToRepair(EItem_defined_transformation transformation, ASdaiModel models, Importer importer) throws SdaiException {
        boolean needToSearchForInverses = false;
        if (transformation.testTransform_item_1(null) && transformation.getTransform_item_1(null) instanceof ECartesian_transformation_operator) {
            if (transformation.testTransform_item_2(null) && transformation.getTransform_item_2(null) instanceof EPlacement) {
                needToSearchForInverses = true;
            } else {
                importer.logMessage(" Unsupported combination of item_1 and item_2 for " + transformation);
            }
        } else if (transformation.testTransform_item_2(null) && transformation.getTransform_item_2(null) instanceof ECartesian_transformation_operator) {
            if (transformation.testTransform_item_1(null) && transformation.getTransform_item_1(null) instanceof EPlacement) {
                needToSearchForInverses = true;
            } else {
                importer.logMessage(" Unsupported combination of item_1 and item_2 for " + transformation);
            }
        }
        if (needToSearchForInverses) {
            ARepresentation_relationship_with_transformation result = new ARepresentation_relationship_with_transformation();
            CRepresentation_relationship_with_transformation.usedinTransformation_operator(null, (EEntity)transformation, (ASdaiModel)models, (AEntity)result);
            return result;
        }
        return null;
    }

    private static ECartesian_transformation_operator getCTO(EItem_defined_transformation transformation, ASdaiModel domain, Importer importer) throws SdaiException {
        ECartesian_transformation_operator ecto;
        if (transformation.testTransform_item_1(null) && transformation.getTransform_item_1(null) instanceof ECartesian_transformation_operator) {
            ecto = (ECartesian_transformation_operator)transformation.getTransform_item_1(null);
            if (transformation.testTransform_item_2(null) && transformation.getTransform_item_2(null) instanceof EPlacement) {
                EPlacement placement = (EPlacement)transformation.getTransform_item_2(null);
                Item_defined_transformationRepair.raiseErrorOrWarning(placement, transformation, importer);
                return ecto;
            }
        }
        if (transformation.testTransform_item_2(null) && transformation.getTransform_item_2(null) instanceof ECartesian_transformation_operator) {
            ecto = (ECartesian_transformation_operator)transformation.getTransform_item_2(null);
            if (transformation.testTransform_item_1(null) && transformation.getTransform_item_1(null) instanceof EPlacement) {
                EPlacement placement = (EPlacement)transformation.getTransform_item_1(null);
                Item_defined_transformationRepair.raiseErrorOrWarning(placement, transformation, importer);
                return ecto;
            }
        }
        return null;
    }

    private static void raiseErrorOrWarning(EPlacement placement, EItem_defined_transformation transformation, Importer importer) throws SdaiException {
        String ERROR_MESSAGE = "Item_definition_transformation has Axis_placment with non zero transformation AND Cartesian_transformation_operation " + transformation;
        String WARNING_MESSAGE = "Item_definition_transformation has Axis_placment AND Cartesian_transformation_operation - transforming to geometric_relationship_with_operator_transformation" + transformation;
        if (placement instanceof EAxis2_placement_2d) {
            double y;
            double x;
            EDirection dir;
            EAxis2_placement_2d eap2d = (EAxis2_placement_2d)placement;
            if (eap2d.testRef_direction(null) && (dir = eap2d.getRef_direction(null)).testDirection_ratios(null)) {
                A_double ratios = dir.getDirection_ratios(null);
                x = ratios.getByIndex(1);
                y = ratios.getByIndex(2);
                if (Math.abs(x - 1.0) > (double)1.0E-5f || Math.abs(y) > (double)1.0E-5f) {
                    importer.errorMessage(ERROR_MESSAGE);
                    return;
                }
            }
            if (eap2d.testLocation(null)) {
                ECartesian_point location = eap2d.getLocation(null);
                A_double coords = location.getCoordinates(null);
                x = coords.getByIndex(1);
                y = coords.getByIndex(2);
                if (Math.abs(x) > (double)1.0E-5f || Math.abs(y) > (double)1.0E-5f) {
                    importer.errorMessage(ERROR_MESSAGE);
                    return;
                }
            }
        } else if (placement instanceof EAxis2_placement_3d) {
            double z;
            double y;
            double x;
            A_double ratios;
            EDirection dir;
            EAxis2_placement_3d eap3d = (EAxis2_placement_3d)placement;
            if (eap3d.testRef_direction(null) && (dir = eap3d.getRef_direction(null)).testDirection_ratios(null)) {
                ratios = dir.getDirection_ratios(null);
                x = ratios.getByIndex(1);
                y = ratios.getByIndex(2);
                z = ratios.getByIndex(3);
                if (Math.abs(x - 1.0) > (double)1.0E-5f || Math.abs(y) > (double)1.0E-5f || Math.abs(z) > (double)1.0E-5f) {
                    importer.errorMessage(ERROR_MESSAGE);
                    return;
                }
            }
            if (eap3d.testAxis(null) && (dir = eap3d.getAxis(null)).testDirection_ratios(null)) {
                ratios = dir.getDirection_ratios(null);
                x = ratios.getByIndex(1);
                y = ratios.getByIndex(2);
                z = ratios.getByIndex(3);
                if (Math.abs(x) > (double)1.0E-5f || Math.abs(y) > (double)1.0E-5f || Math.abs(z - 1.0) > (double)1.0E-5f) {
                    importer.errorMessage(ERROR_MESSAGE);
                    return;
                }
            }
            if (eap3d.testLocation(null)) {
                ECartesian_point location = eap3d.getLocation(null);
                A_double coords = location.getCoordinates(null);
                x = coords.getByIndex(1);
                y = coords.getByIndex(2);
                z = coords.getByIndex(2);
                if (Math.abs(x) > (double)1.0E-5f || Math.abs(y) > (double)1.0E-5f || Math.abs(z) > (double)1.0E-5f) {
                    importer.errorMessage(ERROR_MESSAGE);
                    return;
                }
            }
        }
        importer.logMessage(WARNING_MESSAGE);
    }
}

