/*
 * Decompiled with CFR 0.152.
 */
package jsdaix.processor.xim_aim.pre.manual_aim_repair;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jsdai.SPerson_organization_assignment_mim.AApplied_organization_assignment;
import jsdai.SPerson_organization_assignment_mim.AApplied_person_and_organization_assignment;
import jsdai.SPerson_organization_assignment_mim.CApplied_organization_assignment;
import jsdai.SPerson_organization_assignment_mim.CApplied_person_and_organization_assignment;
import jsdai.SPerson_organization_assignment_mim.EApplied_organization_assignment;
import jsdai.SPerson_organization_assignment_mim.EApplied_person_and_organization_assignment;
import jsdai.SPerson_organization_schema.EOrganization_role;
import jsdai.SPerson_organization_schema.EPerson_and_organization_role;
import jsdai.dictionary.EEntity_definition;
import jsdai.lang.ASdaiModel;
import jsdai.lang.SdaiException;
import jsdai.lang.SdaiIterator;
import jsdaix.processor.xim_aim.pre.Importer;

public class RolesRepair {
    public static final Map ORGANIZATION_ROLES;

    private RolesRepair() {
    }

    public static void run(ASdaiModel domain, Importer importer) throws SdaiException {
        RolesRepair.repairApaoaRoles(domain, importer);
        RolesRepair.repairAoaRoles(domain, importer);
    }

    private static void repairApaoaRoles(ASdaiModel domain, Importer importer) throws SdaiException {
        AApplied_person_and_organization_assignment aApaoa = (AApplied_person_and_organization_assignment)domain.getInstances((EEntity_definition)CApplied_person_and_organization_assignment.definition);
        SdaiIterator i = aApaoa.createIterator();
        while (i.next()) {
            String role;
            String correctRole;
            EPerson_and_organization_role eRole;
            EApplied_person_and_organization_assignment eApaoa = aApaoa.getCurrentMember(i);
            if (!eApaoa.testRole(null) || !(eRole = eApaoa.getRole(null)).testName(null) || (correctRole = RolesRepair.getCorrectRole(ORGANIZATION_ROLES, role = eRole.getName(null))) == null) continue;
            eRole.setName(null, correctRole);
            importer.logMessage("Fixing role name for " + eRole);
        }
    }

    private static void repairAoaRoles(ASdaiModel domain, Importer importer) throws SdaiException {
        AApplied_organization_assignment aAoa = (AApplied_organization_assignment)domain.getInstances((EEntity_definition)CApplied_organization_assignment.definition);
        SdaiIterator i = aAoa.createIterator();
        while (i.next()) {
            String role;
            String correctRole;
            EOrganization_role eRole;
            EApplied_organization_assignment eAoa = aAoa.getCurrentMember(i);
            if (!eAoa.testRole(null) || !(eRole = eAoa.getRole(null)).testName(null) || (correctRole = RolesRepair.getCorrectRole(ORGANIZATION_ROLES, role = eRole.getName(null))) == null) continue;
            eRole.setName(null, correctRole);
            importer.logMessage("Fixing role name for " + eRole);
        }
    }

    private static String getCorrectRole(Map roles, String role) {
        Iterator i = roles.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            if (!role.equalsIgnoreCase((String)entry.getKey())) continue;
            return (String)entry.getValue();
        }
        return null;
    }

    static {
        HashMap<String, String> roles = new HashMap<String, String>();
        roles.put("author", "author");
        roles.put("classification_officer", "classification officer");
        roles.put("creator", "creator");
        roles.put("custodian", "custodian");
        roles.put("customer", "customer");
        roles.put("design_supplier", "design supplier");
        roles.put("editor", "editor");
        roles.put("id_owner", "id owner");
        roles.put("location", "location");
        roles.put("manufacturer", "manufacturer");
        roles.put("owner", "owner");
        roles.put("read_access", "read access");
        roles.put("supplier", "supplier");
        roles.put("wholesaler", "wholesaler");
        roles.put("write_access", "write access");
        roles.put("organization_in_contract", "organization in contract");
        ORGANIZATION_ROLES = Collections.unmodifiableMap(roles);
    }
}

