/*
 * Decompiled with CFR 0.152.
 */
package jsdaix.processor.xim_aim.pre.manual_aim_repair;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import jsdai.SAic_associative_draughting_elements.ADraughting_model;
import jsdai.SAic_associative_draughting_elements.CDraughting_model;
import jsdai.SAic_associative_draughting_elements.EDraughting_model;
import jsdai.SAic_mechanical_design_geometric_presentation.AMechanical_design_geometric_presentation_representation;
import jsdai.SAic_mechanical_design_geometric_presentation.CMechanical_design_geometric_presentation_representation;
import jsdai.SAic_mechanical_design_geometric_presentation.EMechanical_design_geometric_presentation_representation;
import jsdai.SAic_mechanical_design_shaded_presentation.AMechanical_design_shaded_presentation_representation;
import jsdai.SAic_mechanical_design_shaded_presentation.CMechanical_design_shaded_presentation_representation;
import jsdai.SAic_mechanical_design_shaded_presentation.EMechanical_design_shaded_presentation_representation;
import jsdai.SDraughting_element_schema.AAnnotation_plane;
import jsdai.SDraughting_element_schema.ADraughting_callout;
import jsdai.SDraughting_element_schema.CAnnotation_plane;
import jsdai.SDraughting_element_schema.CDraughting_callout;
import jsdai.SDraughting_element_schema.EAnnotation_plane;
import jsdai.SDraughting_element_schema.EDraughting_callout;
import jsdai.SPresentation_appearance_schema.APresentation_style_select;
import jsdai.SPresentation_appearance_schema.AStyled_item;
import jsdai.SPresentation_appearance_schema.CPresentation_style_assignment;
import jsdai.SPresentation_appearance_schema.CStyled_item;
import jsdai.SPresentation_appearance_schema.ENull_style;
import jsdai.SPresentation_appearance_schema.EPresentation_style_assignment;
import jsdai.SPresentation_appearance_schema.EStyled_item;
import jsdai.SPresentation_definition_schema.AAnnotation_occurrence;
import jsdai.SPresentation_definition_schema.AText_literal;
import jsdai.SPresentation_definition_schema.CAnnotation_occurrence;
import jsdai.SPresentation_definition_schema.CText_literal;
import jsdai.SPresentation_definition_schema.EAnnotation_occurrence;
import jsdai.SPresentation_definition_schema.EText_literal;
import jsdai.SProduct_property_representation_schema.EShape_representation;
import jsdai.SRepresentation_schema.ARepresentation;
import jsdai.SRepresentation_schema.ARepresentation_item;
import jsdai.SRepresentation_schema.ARepresentation_relationship;
import jsdai.SRepresentation_schema.CRepresentation;
import jsdai.SRepresentation_schema.CRepresentation_relationship;
import jsdai.SRepresentation_schema.EMapped_item;
import jsdai.SRepresentation_schema.ERepresentation;
import jsdai.SRepresentation_schema.ERepresentation_context;
import jsdai.SRepresentation_schema.ERepresentation_item;
import jsdai.SRepresentation_schema.ERepresentation_map;
import jsdai.SRepresentation_schema.ERepresentation_relationship;
import jsdai.dictionary.EEntity_definition;
import jsdai.lang.AEntity;
import jsdai.lang.ASdaiModel;
import jsdai.lang.EEntity;
import jsdai.lang.SdaiException;
import jsdai.lang.SdaiIterator;
import jsdai.lang.SdaiModel;
import jsdaix.processor.xim_aim.pre.Importer;

public class StylingModelRepair {
    public static void run(ASdaiModel models, Importer importer) throws SdaiException {
        StylingModelRepair.changeStylingModelType(models, importer);
        StylingModelRepair.mappedItemRepair(models, importer);
    }

    public static void runAfterMapping(ASdaiModel models, Importer importer) throws SdaiException {
        StylingModelRepair.annotationStuffCleaningRepair(models, importer);
    }

    private static void changeStylingModelType(ASdaiModel models, Importer importer) throws SdaiException {
        AMechanical_design_geometric_presentation_representation items = (AMechanical_design_geometric_presentation_representation)models.getExactInstances((EEntity_definition)CMechanical_design_geometric_presentation_representation.definition);
        SdaiIterator it = items.createIterator();
        while (it.next()) {
            EMechanical_design_geometric_presentation_representation item = items.getCurrentMember(it);
            EEntity instance = item.findEntityInstanceSdaiModel().substituteInstance((EEntity)item, (EEntity_definition)CDraughting_model.definition);
            importer.logMessage("Changed Mechanical_design_geometric_presentation_representation to " + instance);
        }
        AMechanical_design_shaded_presentation_representation items2 = (AMechanical_design_shaded_presentation_representation)models.getExactInstances((EEntity_definition)CMechanical_design_shaded_presentation_representation.definition);
        SdaiIterator it2 = items2.createIterator();
        while (it2.next()) {
            EMechanical_design_shaded_presentation_representation item = items2.getCurrentMember(it2);
            EEntity instance = item.findEntityInstanceSdaiModel().substituteInstance((EEntity)item, (EEntity_definition)CDraughting_model.definition);
            importer.logMessage("Changed Mechanical_design_shaded_presentation_representation to " + instance);
        }
    }

    private static void annotationStuffCleaningRepair(ASdaiModel models, Importer importer) throws SdaiException {
        long time = System.currentTimeMillis();
        ADraughting_callout adc = (ADraughting_callout)models.getInstances((EEntity_definition)CDraughting_callout.definition);
        SdaiIterator it = adc.createIterator();
        while (it.next()) {
            EDraughting_callout item = adc.getCurrentMember(it);
            StylingModelRepair.cleanUpStyledItem((ERepresentation_item)item, models, importer);
            StylingModelRepair.cleanCallouts(item, models, importer);
        }
        AAnnotation_plane aap = (AAnnotation_plane)models.getInstances((EEntity_definition)CAnnotation_plane.definition);
        SdaiIterator it2 = aap.createIterator();
        while (it2.next()) {
            EAnnotation_plane item = aap.getCurrentMember(it2);
            StylingModelRepair.cleanUpStyledItem((ERepresentation_item)item, models, importer);
        }
        AAnnotation_occurrence items = (AAnnotation_occurrence)models.getExactInstances((EEntity_definition)CAnnotation_occurrence.definition);
        SdaiIterator it3 = items.createIterator();
        while (it3.next()) {
            EAnnotation_occurrence item = items.getCurrentMember(it3);
            StylingModelRepair.cleanUpStyledItem((ERepresentation_item)item, models, importer);
        }
        AText_literal ati = (AText_literal)models.getInstances((EEntity_definition)CText_literal.definition);
        SdaiIterator it4 = ati.createIterator();
        while (it4.next()) {
            EText_literal item = ati.getCurrentMember(it4);
            StylingModelRepair.cleanUpItem((ERepresentation_item)item, models, importer);
        }
    }

    private static void cleanCallouts(EDraughting_callout item, ASdaiModel models, Importer importer) throws SdaiException {
        ARepresentation reps = new ARepresentation();
        CRepresentation.usedinItems(null, (ERepresentation_item)item, (ASdaiModel)models, (AEntity)reps);
        for (int i = 1; i <= reps.getMemberCount(); ++i) {
            ERepresentation er = reps.getByIndex(i);
            if (!(er instanceof EShape_representation)) continue;
            er.getItems(null).removeUnordered((EEntity)item);
            importer.errorMessage(" Removing callout from shape_rep " + item + " from " + er);
        }
    }

    private static void cleanUpItem(ERepresentation_item item, ASdaiModel models, Importer importer) throws SdaiException {
        ARepresentation reps = new ARepresentation();
        CRepresentation.usedinItems(null, (ERepresentation_item)item, (ASdaiModel)models, (AEntity)reps);
        AStyled_item asi = new AStyled_item();
        CStyled_item.usedinItem(null, (ERepresentation_item)item, (ASdaiModel)models, (AEntity)asi);
        if (reps.getMemberCount() + asi.getMemberCount() <= 1) {
            return;
        }
        boolean stillHasUser = asi.getMemberCount() > 0;
        for (int i = 1; i <= reps.getMemberCount(); ++i) {
            ERepresentation er = reps.getByIndex(i);
            if (!stillHasUser && i >= reps.getMemberCount()) continue;
            er.getItems(null).removeUnordered((EEntity)item);
            importer.errorMessage(" Removing invalid item " + item + " from " + er);
        }
    }

    private static void cleanUpStyledItem(ERepresentation_item item, ASdaiModel models, Importer importer) throws SdaiException {
        Set<EDraughting_model> child;
        EDraughting_model dm1;
        ARepresentation reps = new ARepresentation();
        CRepresentation.usedinItems(null, (ERepresentation_item)item, (ASdaiModel)models, (AEntity)reps);
        Set indirectReps = StylingModelRepair.collectAllIndirectReps(item, models);
        if (reps.getMemberCount() + indirectReps.size() <= 1) {
            return;
        }
        boolean stillHasShape = false;
        HashSet<ERepresentation> dms = new HashSet<ERepresentation>();
        for (int i = 1; i <= reps.getMemberCount(); ++i) {
            ERepresentation er = reps.getByIndex(i);
            if (er instanceof EDraughting_model) {
                stillHasShape = true;
                dms.add(er);
                continue;
            }
            if (!stillHasShape && i >= reps.getMemberCount()) continue;
            er.getItems(null).removeUnordered((EEntity)item);
            importer.errorMessage(" Removing duplicate item " + item + " from " + er);
        }
        dms.addAll(indirectReps);
        HashMap<EDraughting_model, Set<EDraughting_model>> parent2Child = new HashMap<EDraughting_model, Set<EDraughting_model>>();
        Iterator it1 = dms.iterator();
        while (it1.hasNext()) {
            dm1 = (EDraughting_model)it1.next();
            child = (HashSet)parent2Child.get(dm1);
            if (child == null) {
                child = new HashSet();
                parent2Child.put(dm1, child);
            }
            Iterator it2 = dms.iterator();
            while (it2.hasNext()) {
                EDraughting_model dm2 = (EDraughting_model)it2.next();
                if (dm1 == dm2 || !StylingModelRepair.isParent(dm1, dm2, item, models)) continue;
                child.add(dm2);
            }
        }
        it1 = dms.iterator();
        while (it1.hasNext()) {
            dm1 = (EDraughting_model)it1.next();
            child = (Set)parent2Child.get(dm1);
            if (child.size() <= 0) continue;
            StylingModelRepair.removeItemFromModelIfNeeded(item, dm1, indirectReps, importer, models);
            if (child.size() <= 1) continue;
            boolean oneKept = false;
            Iterator it2 = child.iterator();
            while (it2.hasNext()) {
                EDraughting_model dm2 = (EDraughting_model)it2.next();
                if (oneKept) {
                    StylingModelRepair.removeItemFromModelIfNeeded(item, dm2, indirectReps, importer, models);
                    continue;
                }
                oneKept = true;
            }
        }
    }

    private static Set collectAllIndirectReps(ERepresentation_item item, ASdaiModel models) throws SdaiException {
        HashSet<ERepresentation> result = new HashSet<ERepresentation>();
        ADraughting_callout adc = new ADraughting_callout();
        CDraughting_callout.usedinContents(null, (EEntity)item, (ASdaiModel)models, (AEntity)adc);
        int n = adc.getMemberCount();
        for (int i = 1; i <= n; ++i) {
            EDraughting_callout edc = adc.getByIndex(i);
            ARepresentation ar = new ARepresentation();
            CRepresentation.usedinItems(null, (ERepresentation_item)edc, (ASdaiModel)models, (AEntity)ar);
            int r = ar.getMemberCount();
            for (int j = 1; j <= r; ++j) {
                ERepresentation er = ar.getByIndex(j);
                if (!(er instanceof EDraughting_model)) continue;
                result.add(er);
            }
        }
        AAnnotation_plane aap = new AAnnotation_plane();
        CAnnotation_plane.usedinElements(null, (EEntity)item, (ASdaiModel)models, (AEntity)aap);
        int n2 = aap.getMemberCount();
        for (int i = 1; i <= n2; ++i) {
            EAnnotation_plane eap = aap.getByIndex(i);
            ARepresentation ar = new ARepresentation();
            CRepresentation.usedinItems(null, (ERepresentation_item)eap, (ASdaiModel)models, (AEntity)ar);
            int r = ar.getMemberCount();
            for (int j = 1; j <= r; ++j) {
                ERepresentation er = ar.getByIndex(j);
                if (!(er instanceof EDraughting_model)) continue;
                result.add(er);
            }
        }
        return result;
    }

    private static void removeItemFromModelIfNeeded(ERepresentation_item item, EDraughting_model dm1, Set indirectReps, Importer importer, ASdaiModel domain) throws SdaiException {
        ARepresentation_item items = dm1.getItems(null);
        if (items.isMember((EEntity)item)) {
            items.removeUnordered((EEntity)item);
            importer.errorMessage(" Removing duplicate item " + item + " from " + dm1);
        } else if (indirectReps.contains(dm1)) {
            boolean actionDone = false;
            AAnnotation_plane aap = new AAnnotation_plane();
            CAnnotation_plane.usedinElements(null, (EEntity)item, (ASdaiModel)domain, (AEntity)aap);
            int count = aap.getMemberCount();
            for (int i = 1; i <= count; ++i) {
                EAnnotation_plane eap = aap.getByIndex(i);
                if (items.isMember((EEntity)eap)) {
                    eap.getElements(null).removeUnordered((EEntity)item);
                    actionDone = true;
                    importer.errorMessage(" Removing duplicate item " + item + " from " + eap);
                }
                if (eap.getElements(null).getMemberCount() != 0) continue;
                eap.deleteApplicationInstance();
                importer.logMessage(" Deleting " + eap + " which no longer have any elements ");
            }
            ADraughting_callout adc = new ADraughting_callout();
            CDraughting_callout.usedinContents(null, (EEntity)item, (ASdaiModel)domain, (AEntity)adc);
            int count2 = adc.getMemberCount();
            for (int i = 1; i <= count2; ++i) {
                EDraughting_callout edc = adc.getByIndex(i);
                if (items.isMember((EEntity)edc)) {
                    edc.getContents(null).removeUnordered((EEntity)item);
                    actionDone = true;
                    importer.errorMessage(" Removing duplicate item " + item + " from " + edc);
                }
                if (edc.getContents(null).getMemberCount() != 0) continue;
                edc.deleteApplicationInstance();
                importer.logMessage(" Deleting " + edc + " which no longer have any elements ");
            }
            if (!actionDone) {
                importer.errorMessage(" Unimplemented case of having annotion_element repeated in complex structures " + item + " indirectly in " + dm1);
            }
        }
    }

    private static boolean isParent(EDraughting_model dm1, EDraughting_model dm2, ERepresentation_item item, ASdaiModel domain) throws SdaiException {
        ARepresentation_relationship arr = new ARepresentation_relationship();
        CRepresentation_relationship.usedinRep_2(null, (ERepresentation)dm1, (ASdaiModel)domain, (AEntity)arr);
        int n = arr.getMemberCount();
        for (int i = 1; i <= n; ++i) {
            ERepresentation_relationship err = arr.getByIndex(i);
            if (!err.testRep_1(null) || err.getRep_1(null) != dm2) continue;
            return true;
        }
        return false;
    }

    private static void mappedItemRepair(ASdaiModel models, Importer importer) throws SdaiException {
        ADraughting_model adm = (ADraughting_model)models.getExactInstances((EEntity_definition)CDraughting_model.definition);
        SdaiIterator it = adm.createIterator();
        while (it.next()) {
            EDraughting_model edm = adm.getCurrentMember(it);
            if (!edm.testItems(null)) continue;
            ARepresentation_item items = edm.getItems(null);
            int i = 1;
            while (i <= items.getMemberCount()) {
                ERepresentation er;
                ERepresentation_map erm;
                EMapped_item emi;
                ERepresentation_item item = items.getByIndex(i);
                if (item instanceof EMapped_item && (emi = (EMapped_item)item).testMapping_source(null) && (erm = emi.getMapping_source(null)).testMapped_representation(null) && (er = erm.getMapped_representation(null)).testContext_of_items(null)) {
                    ERepresentation_context erc = edm.getContext_of_items(null);
                    edm.setContext_of_items(null, er.getContext_of_items(null));
                    items.removeUnordered((EEntity)emi);
                    SdaiModel model = emi.findEntityInstanceSdaiModel();
                    EStyled_item esi = (EStyled_item)model.createEntityInstance((EEntity_definition)CStyled_item.definition);
                    esi.setItem(null, (ERepresentation_item)emi);
                    items.addUnordered((EEntity)esi);
                    EPresentation_style_assignment epsa = (EPresentation_style_assignment)model.createEntityInstance((EEntity_definition)CPresentation_style_assignment.definition);
                    APresentation_style_select apss = epsa.createStyles(null);
                    apss.addUnordered(1, (ENull_style)null);
                    esi.createStyles(null).addUnordered((EEntity)epsa);
                    importer.errorMessage(" Change DM -> MI -> RM -> SR to DM -> SI -> MI -> RM -> SR. Added new SI " + esi);
                    continue;
                }
                ++i;
            }
        }
    }
}

