/*
 * Decompiled with CFR 0.152.
 */
package jsdaix.processor.xim_aim.pre.manual_arm_repair;

import jsdai.SApplication_context_schema.CApplication_context;
import jsdai.SGeometry_schema.CGeometric_representation_context;
import jsdai.SManagement_resources_schema.CClassification_role;
import jsdai.SPerson_organization_schema.COrganization_role;
import jsdai.SPerson_organization_schema.CPerson_and_organization_role;
import jsdai.SProduct_property_definition_schema.CCharacterized_object;
import jsdai.SProduct_property_definition_schema.CProduct_definition_shape;
import jsdai.SProduct_property_representation_schema.CShape_representation;
import jsdai.SQualified_measure_schema.CMeasure_qualification;
import jsdai.SQualified_measure_schema.CPrecision_qualifier;
import jsdai.SRepresentation_schema.CRepresentation_map;
import jsdai.SSecurity_classification_schema.CSecurity_classification_level;
import jsdai.SShape_property_assignment_xim.CContextual_item_shape;
import jsdai.dictionary.EEntity_definition;
import jsdai.lang.AEntity;
import jsdai.lang.ASdaiModel;
import jsdai.lang.EEntity;
import jsdai.lang.SdaiException;
import jsdai.util.LangUtils;
import jsdaix.processor.xim_aim.pre.Importer;

public class AIMGarbageCleaner {
    public static void run(ASdaiModel models, EEntity_definition[] typesToRemove, Importer importer) throws SdaiException {
        int count = typesToRemove.length;
        for (int t = 0; t < count; ++t) {
            EEntity_definition typeToRemove = typesToRemove[t];
            AIMGarbageCleaner.deleteExactInstances(models, typeToRemove, importer);
        }
        AEntity instancesToRemove = models.getExactInstances((EEntity_definition)CShape_representation.definition);
        int index = 1;
        while (instancesToRemove.getMemberCount() > index - 1) {
            EEntity instanceToRemove = instancesToRemove.getByIndexEntity(index);
            boolean deleted = LangUtils.deleteInstanceIfUsageCountLessThan((ASdaiModel)models, (EEntity)instanceToRemove, (int)1);
            if (deleted) continue;
            ++index;
        }
        AIMGarbageCleaner.removeUnusedEntities(models, (EEntity_definition)CClassification_role.definition, importer);
        AIMGarbageCleaner.removeUnusedEntities(models, (EEntity_definition)CGeometric_representation_context.definition, importer);
        AIMGarbageCleaner.removeUnusedEntities(models, (EEntity_definition)CApplication_context.definition, importer);
        AIMGarbageCleaner.removeUnusedEntities(models, (EEntity_definition)CProduct_definition_shape.definition, importer);
        AIMGarbageCleaner.removeUnusedEntities(models, (EEntity_definition)COrganization_role.definition, importer);
        AIMGarbageCleaner.removeUnusedEntities(models, (EEntity_definition)CCharacterized_object.definition, importer);
        AIMGarbageCleaner.removeUnusedEntities(models, (EEntity_definition)CContextual_item_shape.definition, importer);
        AIMGarbageCleaner.removeUnusedEntities(models, (EEntity_definition)CPerson_and_organization_role.definition, importer);
        AIMGarbageCleaner.removeUnusedEntities(models, (EEntity_definition)CSecurity_classification_level.definition, importer);
        AIMGarbageCleaner.removeUnusedEntities(models, (EEntity_definition)CMeasure_qualification.definition, importer);
        AIMGarbageCleaner.removeUnusedEntities(models, (EEntity_definition)CPrecision_qualifier.definition, importer);
        AIMGarbageCleaner.removeUnusedEntities(models, (EEntity_definition)CRepresentation_map.definition, importer);
    }

    private static void removeUnusedEntities(ASdaiModel models, EEntity_definition typeToRemove, Importer importer) throws SdaiException {
        AEntity instancesToRemove = models.getExactInstances(typeToRemove);
        int index = 1;
        while (instancesToRemove.getMemberCount() > index - 1) {
            EEntity instanceToRemove = instancesToRemove.getByIndexEntity(index);
            String message = "Deleted unused instance " + instanceToRemove;
            boolean deleted = LangUtils.deleteInstanceIfUsageCountLessThan((ASdaiModel)models, (EEntity)instanceToRemove, (int)1);
            if (!deleted) {
                ++index;
                continue;
            }
            importer.logMessage(message);
        }
    }

    private static void deleteExactInstances(ASdaiModel models, EEntity_definition typeToRemove, Importer importer) throws SdaiException {
        AEntity instancesToRemove = models.getExactInstances(typeToRemove);
        int count = instancesToRemove.getMemberCount();
        while (count > 0) {
            EEntity instanceToRemove = instancesToRemove.getByIndexEntity(count--);
            importer.logMessage(" Deleting instance " + instanceToRemove);
            instanceToRemove.deleteApplicationInstance();
        }
    }
}

