/*
 * Decompiled with CFR 0.152.
 */
package jsdaix.processor.xim_aim.pre.manual_arm_repair;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jsdai.SDocument_and_version_identification_xim.CDocument_version;
import jsdai.SDocument_and_version_identification_xim.EDocument_armx;
import jsdai.SDocument_and_version_identification_xim.EDocument_version;
import jsdai.SDocument_assignment_xim.ADocument_assignment;
import jsdai.SDocument_assignment_xim.CDocument_assignment;
import jsdai.SDocument_assignment_xim.EDocument_assignment;
import jsdai.SDocument_definition_xim.EDocument_definition;
import jsdai.SDocument_schema.ADocument;
import jsdai.SDocument_schema.EDocument;
import jsdai.SPart_and_version_identification_xim.CPart_version;
import jsdai.SPart_and_version_identification_xim.EPart;
import jsdai.SPart_and_version_identification_xim.EPart_version;
import jsdai.SPart_view_definition_xim.EPart_view_definition;
import jsdai.SProduct_breakdown_xim.CBreakdown_version;
import jsdai.SProduct_breakdown_xim.EBreakdown;
import jsdai.SProduct_breakdown_xim.EBreakdown_element;
import jsdai.SProduct_breakdown_xim.EBreakdown_element_definition;
import jsdai.SProduct_breakdown_xim.EBreakdown_version;
import jsdai.SProduct_definition_schema.CProduct_definition;
import jsdai.SProduct_definition_schema.CProduct_definition_with_associated_documents;
import jsdai.SProduct_definition_schema.EProduct;
import jsdai.SProduct_definition_schema.EProduct_definition;
import jsdai.SProduct_definition_schema.EProduct_definition_formation;
import jsdai.SProduct_definition_schema.EProduct_definition_with_associated_documents;
import jsdai.dictionary.EEntity_definition;
import jsdai.lang.AEntity;
import jsdai.lang.ASdaiModel;
import jsdai.lang.EEntity;
import jsdai.lang.SdaiException;
import jsdai.lang.SdaiIterator;
import jsdai.lang.SdaiModel;
import jsdaix.processor.xim_aim.pre.Importer;

public class DefinitionsRepair {
    public static void run(ASdaiModel models, Importer importer) throws SdaiException {
        List productDefinitionList = DefinitionsRepair.getDefinitions(models);
        Iterator it = productDefinitionList.iterator();
        while (it.hasNext()) {
            EProduct_definition productDefinition = (EProduct_definition)it.next();
            DefinitionsRepair.repairDocuments(productDefinition, models, importer);
            DefinitionsRepair.repairType(productDefinition, importer);
        }
    }

    private static void repairDocuments(EProduct_definition productDefinition, ASdaiModel domain, Importer importer) throws SdaiException {
        if (!(productDefinition instanceof EProduct_definition_with_associated_documents)) {
            return;
        }
        EProduct_definition_with_associated_documents pdwss = (EProduct_definition_with_associated_documents)productDefinition;
        if (!pdwss.testDocumentation_ids(null)) {
            return;
        }
        AEntity assignedDocuments = DefinitionsRepair.getAssignedDocuments((EProduct_definition)pdwss, domain, importer);
        SdaiModel model = pdwss.findEntityInstanceSdaiModel();
        ADocument documents = pdwss.getDocumentation_ids(null);
        SdaiIterator i = documents.createIterator();
        while (i.next()) {
            EDocument doc = documents.getCurrentMember(i);
            if (assignedDocuments.isMember((EEntity)doc)) continue;
            EDocument_assignment da = (EDocument_assignment)model.createEntityInstance((EEntity_definition)CDocument_assignment.definition);
            da.setAssigned_document_x(null, (EEntity)doc);
            da.createIs_assigned_to(null).addUnordered((EEntity)pdwss);
            da.setRole_x(null, "");
            importer.logMessage(" Created new instance " + da);
        }
    }

    private static AEntity getAssignedDocuments(EProduct_definition productDefinition, ASdaiModel domain, Importer importer) throws SdaiException {
        AEntity assignedDocuments = new AEntity();
        ADocument_assignment aDa = new ADocument_assignment();
        CDocument_assignment.usedinIs_assigned_to(null, (EEntity)productDefinition, (ASdaiModel)domain, (AEntity)aDa);
        SdaiIterator i = aDa.createIterator();
        while (i.next()) {
            EEntity eDoc;
            EDocument_assignment eDa = aDa.getCurrentMember(i);
            if (!eDa.testAssigned_document_x(null) || assignedDocuments.isMember(eDoc = eDa.getAssigned_document_x(null))) continue;
            assignedDocuments.addUnordered(eDoc);
            importer.logMessage(" Added " + eDoc + " to assigned documents ");
        }
        return assignedDocuments;
    }

    private static void repairType(EProduct_definition productDefinition, Importer importer) throws SdaiException {
        if (!productDefinition.testFormation(null)) {
            return;
        }
        EProduct_definition_formation version = productDefinition.getFormation(null);
        if (!version.testOf_product(null)) {
            return;
        }
        EProduct product = version.getOf_product(null);
        if (product instanceof EPart) {
            if (productDefinition.testFrame_of_reference(null)) {
                productDefinition.getFrame_of_reference(null).setName(null, "part definition");
            }
            productDefinition.findEntityInstanceSdaiModel().substituteInstance((EEntity)productDefinition, EPart_view_definition.class);
            if (!(version instanceof EPart_version)) {
                String message = " Changed " + version;
                EEntity instance = version.findEntityInstanceSdaiModel().substituteInstance((EEntity)version, (EEntity_definition)CPart_version.definition);
                importer.logMessage(message + " to " + instance);
            }
        } else if (product instanceof EDocument_armx) {
            productDefinition.findEntityInstanceSdaiModel().substituteInstance((EEntity)productDefinition, EDocument_definition.class);
            if (!(version instanceof EDocument_version)) {
                String message = " Changed " + version;
                EEntity instance = version.findEntityInstanceSdaiModel().substituteInstance((EEntity)version, (EEntity_definition)CDocument_version.definition);
                importer.logMessage(message + " to " + instance);
            }
        } else if (product instanceof EBreakdown || product instanceof EBreakdown_element) {
            productDefinition.findEntityInstanceSdaiModel().substituteInstance((EEntity)productDefinition, EBreakdown_element_definition.class);
            if (!(version instanceof EBreakdown_version)) {
                String message = " Changed " + version;
                EEntity instance = version.findEntityInstanceSdaiModel().substituteInstance((EEntity)version, (EEntity_definition)CBreakdown_version.definition);
                importer.logMessage(message + " to " + instance);
            }
        }
    }

    private static List getDefinitions(ASdaiModel models) throws SdaiException {
        AEntity productDefinitions = models.getExactInstances(CProduct_definition.class);
        ArrayList<EProduct_definition> productDefinitionList = new ArrayList<EProduct_definition>();
        SdaiIterator it = productDefinitions.createIterator();
        while (it.next()) {
            productDefinitionList.add((EProduct_definition)productDefinitions.getCurrentMemberEntity(it));
        }
        productDefinitions = models.getExactInstances(CProduct_definition_with_associated_documents.class);
        it = productDefinitions.createIterator();
        while (it.next()) {
            productDefinitionList.add((EProduct_definition)productDefinitions.getCurrentMemberEntity(it));
        }
        return productDefinitionList;
    }
}

