/*
 * Decompiled with CFR 0.152.
 */
package jsdaix.processor.xim_aim.pre.manual_arm_repair;

import java.util.ArrayList;
import java.util.List;
import jsdai.SProduct_property_definition_schema.CShape_aspect_relationship;
import jsdai.SProduct_property_definition_schema.EShape_aspect;
import jsdai.SProduct_property_definition_schema.EShape_aspect_relationship;
import jsdai.SShape_aspect_definition_schema.EComposite_shape_aspect;
import jsdai.SShape_aspect_definition_schema.EDatum;
import jsdai.SShape_aspect_definition_schema.EDatum_feature;
import jsdai.SShape_aspect_definition_schema.EDatum_target;
import jsdai.dictionary.EEntity_definition;
import jsdai.lang.AEntity;
import jsdai.lang.ASdaiModel;
import jsdai.lang.SdaiException;
import jsdaix.processor.xim_aim.pre.Importer;

public class ShapeAspectRelationshipCleaner {
    private static List removableMagicStrings = new ArrayList();

    public static void run(ASdaiModel models, Importer importer) throws SdaiException {
        removableMagicStrings.add("model coordinate system");
        removableMagicStrings.add("affected plane association");
        removableMagicStrings.add("composing");
        AEntity instancesToClean = models.getExactInstances((EEntity_definition)CShape_aspect_relationship.definition);
        int index = 1;
        while (index <= instancesToClean.getMemberCount()) {
            String name;
            EShape_aspect_relationship instanceToClean = (EShape_aspect_relationship)instancesToClean.getByIndexEntity(index);
            if (instanceToClean.testName(null) && removableMagicStrings.contains(name = instanceToClean.getName(null))) {
                ShapeAspectRelationshipCleaner.deleteWithMessage(importer, instanceToClean);
                continue;
            }
            if (instanceToClean.testRelating_shape_aspect(null)) {
                EShape_aspect relating = instanceToClean.getRelating_shape_aspect(null);
                if (relating instanceof EComposite_shape_aspect) {
                    ShapeAspectRelationshipCleaner.deleteWithMessage(importer, instanceToClean);
                    continue;
                }
                EShape_aspect related = instanceToClean.getRelated_shape_aspect(null);
                if (related instanceof EDatum && (relating instanceof EDatum_feature || relating instanceof EDatum_target)) {
                    ShapeAspectRelationshipCleaner.deleteWithMessage(importer, instanceToClean);
                    continue;
                }
            }
            ++index;
        }
    }

    private static void deleteWithMessage(Importer importer, EShape_aspect_relationship instanceToClean) throws SdaiException {
        importer.logMessage(" Deleting " + instanceToClean);
        instanceToClean.deleteApplicationInstance();
    }
}

