/*
 * Decompiled with CFR 0.152.
 */
package jsdaix.processor.xim_aim.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import jsdai.dictionary.AEntity_definition;
import jsdai.dictionary.EEntity_definition;
import jsdai.dictionary.ESchema_definition;
import jsdai.lang.AEntity;
import jsdai.lang.ASdaiModel;
import jsdai.lang.EEntity;
import jsdai.lang.SdaiException;
import jsdai.lang.SdaiIterator;
import jsdai.lang.SdaiModel;
import jsdai.lang.SdaiRepository;
import jsdai.lang.SdaiSession;
import jsdaix.processor.xim_aim.util.AP203Entities;
import jsdaix.processor.xim_aim.util.AP214Entities;
import jsdaix.processor.xim_aim.util.AP242Entities;
import jsdaix.processor.xim_aim.util.APInstancesProcessor;

public class Utilities {
    private Utilities() {
    }

    public static List findInconsistentEntities(AEntity instances, String schemaName) throws SdaiException {
        APInstancesProcessor processor = null;
        if (schemaName.startsWith("automotive_design")) {
            processor = AP214Entities.getInstance();
        } else if (schemaName.startsWith("ap203")) {
            processor = AP203Entities.getInstance();
        } else if (schemaName.startsWith("ap242")) {
            processor = AP242Entities.getInstance();
        }
        if (processor != null) {
            return processor.findInconsistentEntities(instances);
        }
        ArrayList<EEntity> inconsistentEntities = new ArrayList<EEntity>();
        HashMap<EEntity_definition, Boolean> testedDefinitions = new HashMap<EEntity_definition, Boolean>();
        SdaiRepository systemRepo = SdaiSession.getSession().getSystemRepository();
        SdaiModel dictMod = systemRepo.findSdaiModel(String.valueOf(schemaName + "_DICTIONARY_DATA").toUpperCase());
        dictMod.startReadOnlyAccess();
        ESchema_definition schema = dictMod.getDefinedSchema();
        SdaiIterator it = instances.createIterator();
        while (it.next()) {
            EEntity instance = instances.getCurrentMemberEntity(it);
            EEntity_definition eDef = instance.getInstanceType();
            Boolean wasConsistent = (Boolean)testedDefinitions.get(eDef);
            if (wasConsistent == null) {
                wasConsistent = new Boolean(schema.testEntityDefinition(eDef.getName(null)));
                testedDefinitions.put(eDef, wasConsistent);
            }
            if (wasConsistent.booleanValue()) continue;
            inconsistentEntities.add(instance);
        }
        return inconsistentEntities;
    }

    public static Set getConsistentTypes(String schemaName, EEntity_definition eInputType) throws SdaiException {
        if (schemaName == null) {
            throw new IllegalArgumentException();
        }
        if (eInputType == null) {
            throw new IllegalArgumentException();
        }
        SdaiRepository systemRepo = SdaiSession.getSession().getSystemRepository();
        SdaiModel dictMod = systemRepo.findSdaiModel(String.valueOf(schemaName + "_DICTIONARY_DATA").toUpperCase());
        dictMod.startReadOnlyAccess();
        ESchema_definition schema = dictMod.getDefinedSchema();
        HashSet<EEntity_definition> consistentTypes = new HashSet<EEntity_definition>();
        HashSet<EEntity_definition> uncheckedTypes = new HashSet<EEntity_definition>();
        uncheckedTypes.add(eInputType);
        while (uncheckedTypes.size() > 0) {
            Iterator iterator = uncheckedTypes.iterator();
            EEntity_definition eDef = (EEntity_definition)iterator.next();
            iterator.remove();
            if (schema.testEntityDefinition(eDef.getName(null))) {
                if (eDef.getAbstract_entity(null)) continue;
                consistentTypes.add(eDef);
                continue;
            }
            AEntity_definition aSupertypes = eDef.getSupertypes(null);
            SdaiIterator i = aSupertypes.createIterator();
            while (i.next()) {
                EEntity_definition eSupertype = aSupertypes.getCurrentMember(i);
                if (consistentTypes.contains(eSupertype)) continue;
                uncheckedTypes.add(eSupertype);
            }
        }
        return consistentTypes;
    }

    private static ASdaiModel getSystemDomain(String schemaName) throws SdaiException {
        ASdaiModel domain = new ASdaiModel();
        SdaiRepository systemRepo = SdaiSession.getSession().getSystemRepository();
        SdaiModel systemModel = systemRepo.findSdaiModel(String.valueOf(schemaName + "_DICTIONARY_DATA").toUpperCase());
        if (systemModel == null) {
            return null;
        }
        if (systemModel.getMode() == 0) {
            systemModel.startReadOnlyAccess();
        }
        domain.addUnordered((Object)systemModel, null);
        return domain;
    }
}

