/*
 * Decompiled with CFR 0.152.
 */
package jsdai.tools;

import java.util.HashSet;
import java.util.Set;
import jsdai.SExtended_dictionary_schema.AAttribute;
import jsdai.SExtended_dictionary_schema.AEntity_definition;
import jsdai.SExtended_dictionary_schema.CEntity_declaration;
import jsdai.SExtended_dictionary_schema.EAttribute;
import jsdai.SExtended_dictionary_schema.EDerived_attribute;
import jsdai.SExtended_dictionary_schema.EEntity_declaration;
import jsdai.SExtended_dictionary_schema.EExplicit_attribute;
import jsdai.SExtended_dictionary_schema.EInverse_attribute;
import jsdai.dictionary.EEntity_definition;
import jsdai.lang.AEntity;
import jsdai.lang.ASdaiModel;
import jsdai.lang.SdaiException;
import jsdai.lang.SdaiIterator;
import jsdai.lang.SdaiRepository;
import jsdai.tools.CompareAttributes;
import jsdai.tools.CompareUsefroms;
import jsdai.tools.SearchForRedundantUsefroms;

public final class CheckRedeclaredDerives {
    private CheckRedeclaredDerives() {
    }

    private static void checkAttributes(jsdai.SExtended_dictionary_schema.EEntity_definition eEd, ASdaiModel domain) throws SdaiException {
        AAttribute aAttr = eEd.getAttributes(null, domain);
        SdaiIterator i = aAttr.createIterator();
        while (i.next()) {
            EAttribute eAttr = aAttr.getCurrentMember(i);
            if (!(eAttr instanceof EDerived_attribute) || !CheckRedeclaredDerives.hasDerived(eAttr, domain)) continue;
            System.err.println(eEd.getName(null) + "." + eAttr.getName(null));
        }
    }

    private static EAttribute getRootAttr(EAttribute eAttr) throws SdaiException {
        EAttribute eRoot = eAttr;
        while (eAttr != null) {
            EInverse_attribute eInv;
            EAttribute eRd = null;
            if (eAttr instanceof EDerived_attribute) {
                EDerived_attribute eDer = (EDerived_attribute)eAttr;
                if (eDer.testRedeclaring(null)) {
                    eRd = (EAttribute)eDer.getRedeclaring(null);
                }
            } else if (eAttr instanceof EExplicit_attribute) {
                EExplicit_attribute eExp = (EExplicit_attribute)eAttr;
                if (eExp.testRedeclaring(null)) {
                    eRd = eExp.getRedeclaring(null);
                }
            } else if (eAttr instanceof EInverse_attribute && (eInv = (EInverse_attribute)eAttr).testRedeclaring(null)) {
                eRd = eInv.getRedeclaring(null);
            }
            eRoot = eAttr;
            eAttr = eRd;
        }
        return eRoot;
    }

    private static boolean hasDerived(EAttribute eAttr, ASdaiModel domain) throws SdaiException {
        jsdai.SExtended_dictionary_schema.EEntity_definition eParent = (jsdai.SExtended_dictionary_schema.EEntity_definition)eAttr.getParent(null);
        eAttr = CheckRedeclaredDerives.getRootAttr(eAttr);
        Set supertypes = CheckRedeclaredDerives.getSupertypes(eParent);
        while (supertypes.size() > 0) {
            jsdai.SExtended_dictionary_schema.EEntity_definition eSuper = (jsdai.SExtended_dictionary_schema.EEntity_definition)supertypes.iterator().next();
            supertypes.remove(eSuper);
            supertypes.addAll(CheckRedeclaredDerives.getSupertypes(eSuper));
            AAttribute aAttr = eSuper.getAttributes(null, domain);
            SdaiIterator i = aAttr.createIterator();
            while (i.next()) {
                EAttribute eA = aAttr.getCurrentMember(i);
                if (!(eA instanceof EDerived_attribute) || CheckRedeclaredDerives.getRootAttr(eA) != eAttr) continue;
                return true;
            }
        }
        return false;
    }

    private static Set getSupertypes(jsdai.SExtended_dictionary_schema.EEntity_definition eEd) throws SdaiException {
        HashSet<jsdai.SExtended_dictionary_schema.EEntity_definition> supertypes = new HashSet<jsdai.SExtended_dictionary_schema.EEntity_definition>();
        AEntity_definition aSuper = CompareAttributes.getSupertypes(eEd);
        SdaiIterator i = aSuper.createIterator();
        while (i.next()) {
            supertypes.add(aSuper.getCurrentMember(i));
        }
        return supertypes;
    }

    public static void main(String[] args) throws SdaiException {
        String repoName = "ExpressCompilerRepo";
        System.out.println("Initializing JSDAI...");
        SdaiRepository repo = CompareUsefroms.getRepository(repoName);
        if (repo == null) {
            System.err.println("Unable to open repo: " + repoName);
            return;
        }
        ASdaiModel models = SearchForRedundantUsefroms.activateModels((SdaiRepository)repo);
        AEntity aEd = models.getInstances((EEntity_definition)CEntity_declaration.local_declaration.definition);
        SdaiIterator i = aEd.createIterator();
        while (i.next()) {
            EEntity_declaration eDec = (EEntity_declaration)aEd.getCurrentMemberEntity(i);
            jsdai.SExtended_dictionary_schema.EEntity_definition eEd = (jsdai.SExtended_dictionary_schema.EEntity_definition)eDec.getDefinition(null);
            CheckRedeclaredDerives.checkAttributes(eEd, models);
        }
    }
}

