/*
 * Decompiled with CFR 0.152.
 */
package jsdai.tools;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jsdai.SExtended_dictionary_schema.AAttribute;
import jsdai.SExtended_dictionary_schema.AEntity_definition;
import jsdai.SExtended_dictionary_schema.AEntity_or_view_definition;
import jsdai.SExtended_dictionary_schema.CEntity_declaration;
import jsdai.SExtended_dictionary_schema.EAttribute;
import jsdai.SExtended_dictionary_schema.EDerived_attribute;
import jsdai.SExtended_dictionary_schema.EEntity_declaration;
import jsdai.SExtended_dictionary_schema.EEntity_definition;
import jsdai.SExtended_dictionary_schema.EEntity_or_view_definition;
import jsdai.SExtended_dictionary_schema.EExplicit_attribute;
import jsdai.SExtended_dictionary_schema.EInverse_attribute;
import jsdai.SExtended_dictionary_schema.ELocal_declaration;
import jsdai.SExtended_dictionary_schema.ENamed_type;
import jsdai.SExtended_dictionary_schema.ESchema_definition;
import jsdai.lang.AEntity;
import jsdai.lang.ASdaiModel;
import jsdai.lang.EEntity;
import jsdai.lang.SdaiException;
import jsdai.lang.SdaiIterator;
import jsdai.lang.SdaiModel;
import jsdai.lang.SdaiRepository;
import jsdai.tools.CompareUsefroms;
import jsdai.tools.SearchForRedundantUsefroms;

public final class CompareAttributes {
    public static final Object SCHEMA_KEY = new Object();

    private CompareAttributes() {
    }

    public static Map enumEntities(Set schemaNames, Map schemas) throws SdaiException {
        HashMap entities = new HashMap();
        for (String schemaName : schemaNames) {
            ESchema_definition schema = (ESchema_definition)schemas.get(schemaName);
            entities.putAll(CompareAttributes.enumEntities(schema));
        }
        return entities;
    }

    private static Map enumEntities(ESchema_definition schema) throws SdaiException {
        HashMap<String, EEntity_definition> entities = new HashMap<String, EEntity_definition>();
        SdaiModel model = schema.findEntityInstanceSdaiModel();
        AEntity instances = model.getInstances((jsdai.dictionary.EEntity_definition)CEntity_declaration.definition);
        SdaiIterator i = instances.createIterator();
        while (i.next()) {
            EEntity_declaration eEd = (EEntity_declaration)instances.getCurrentMemberEntity(i);
            if (!(eEd instanceof ELocal_declaration)) continue;
            EEntity_definition eDef = (EEntity_definition)eEd.getDefinition(null);
            eDef.setTemp(SCHEMA_KEY, (Object)schema);
            entities.put(eDef.getName(null), eDef);
        }
        return entities;
    }

    private static void enumReferencedSchemas(ASdaiModel domain, String rootSchema, Map schemas, Set result) throws SdaiException {
        ESchema_definition eSchema = (ESchema_definition)schemas.get(rootSchema);
        Set usefroms = CompareUsefroms.enumAllUsefroms(domain, eSchema);
        for (String usefrom : usefroms) {
            if (result.contains(usefrom)) continue;
            result.add(usefrom);
            CompareAttributes.enumReferencedSchemas(domain, usefrom, schemas, result);
        }
    }

    private static EAttribute getRedeclaring(EAttribute eAttr) throws SdaiException {
        EInverse_attribute eInv;
        EAttribute eRd = null;
        if (eAttr instanceof EDerived_attribute) {
            EDerived_attribute eDer = (EDerived_attribute)eAttr;
            if (eDer.testRedeclaring(null)) {
                eRd = (EAttribute)eDer.getRedeclaring(null);
            }
        } else if (eAttr instanceof EExplicit_attribute) {
            EExplicit_attribute eExp = (EExplicit_attribute)eAttr;
            if (eExp.testRedeclaring(null)) {
                eRd = eExp.getRedeclaring(null);
            }
        } else if (eAttr instanceof EInverse_attribute && (eInv = (EInverse_attribute)eAttr).testRedeclaring(null)) {
            eRd = eInv.getRedeclaring(null);
        }
        return eRd;
    }

    static Map getAttributes(ASdaiModel domain, EEntity_definition eEd, Set redeclaredAttrs) throws SdaiException {
        AAttribute aAttr = eEd.getAttributes(null, domain);
        SdaiIterator i = aAttr.createIterator();
        while (i.next()) {
            EAttribute eAttr = aAttr.getCurrentMember(i);
            EAttribute eRd = CompareAttributes.getRedeclaring(eAttr);
            if (eRd == null) continue;
            redeclaredAttrs.add(eRd);
        }
        HashMap<String, EAttribute> explAttr = new HashMap<String, EAttribute>();
        SdaiIterator i2 = aAttr.createIterator();
        while (i2.next()) {
            EAttribute eAttr = aAttr.getCurrentMember(i2);
            if (redeclaredAttrs.contains(eAttr)) continue;
            explAttr.put(eAttr.getName(null), eAttr);
        }
        AEntity_definition aSuper = CompareAttributes.getSupertypes(eEd);
        SdaiIterator i3 = aSuper.createIterator();
        while (i3.next()) {
            EEntity_definition eSuper = aSuper.getCurrentMember(i3);
            explAttr.putAll(CompareAttributes.getAttributes(domain, eSuper, redeclaredAttrs));
        }
        return explAttr;
    }

    public static AEntity_definition getSupertypes(EEntity_definition eEd) throws SdaiException {
        AEntity_or_view_definition aGenSupertypes = eEd.getGeneric_supertypes(null);
        AEntity_definition aSupertypes = new AEntity_definition();
        SdaiIterator i = aGenSupertypes.createIterator();
        while (i.next()) {
            EEntity eGen = aGenSupertypes.getCurrentMemberEntity(i);
            if (!(eGen instanceof EEntity_definition)) continue;
            aSupertypes.addUnordered(eGen);
        }
        return aSupertypes;
    }

    private static boolean skip(EEntity_definition ximEd) throws SdaiException {
        AEntity_definition ximSupertypes = CompareAttributes.getSupertypes(ximEd);
        if (ximSupertypes.getMemberCount() == 0) {
            System.out.println("XIM entity has no supertypes: " + ximEd.getName(null));
            return true;
        }
        boolean hasDirectXim = false;
        SdaiIterator j = ximSupertypes.createIterator();
        while (j.next()) {
            EEntity_definition eSuper = ximSupertypes.getCurrentMember(j);
            ESchema_definition eSchema = (ESchema_definition)eSuper.getTemp(SCHEMA_KEY);
            if (!eSchema.getName(null).endsWith("_XIM")) continue;
            hasDirectXim = true;
            break;
        }
        return hasDirectXim;
    }

    private static EAttribute getRootAttribute(EAttribute eAttr) throws SdaiException {
        EAttribute eRd = CompareAttributes.getRedeclaring(eAttr);
        if (eRd != null) {
            return CompareAttributes.getRootAttribute(eRd);
        }
        return eAttr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map getIgnoreMap(String ignoreFile) {
        HashMap<String, HashSet<String>> ignore = new HashMap<String, HashSet<String>>();
        Pattern p = Pattern.compile("(\\w+)[.](\\w+)");
        BufferedReader reader = null;
        try {
            String s;
            reader = new BufferedReader(new FileReader(ignoreFile));
            while ((s = reader.readLine()) != null) {
                if ((s = s.trim()).length() == 0) continue;
                Matcher m = p.matcher(s);
                if (m.find()) {
                    String entity = m.group(1);
                    String attr = m.group(2);
                    HashSet<String> set = (HashSet<String>)ignore.get(entity);
                    if (set == null) {
                        set = new HashSet<String>();
                        ignore.put(entity, set);
                    }
                    set.add(attr);
                    continue;
                }
                System.err.println("Wrong format in ignore file: " + s);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return ignore;
    }

    private static void printUsage() {
        System.out.println("Invalid usage. Should be:");
        System.out.println("  java jsdai.tools.CompareAttributes ignoreFile armSchema ximSchema [-s]");
        System.out.println("    ignoreFile - file containing list of ARM attributes to ignore.");
        System.out.println("    armSchema - the arm root schema to take entities for comparison from.");
        System.out.println("    ximSchema - the xim root schema to take entities for comparison from.");
        System.out.println("    -s - flag used to specify that derive messages should be skipped.");
        System.out.println("Note:");
        System.out.println("  Schema names are case sensitive.");
        System.out.println("Example:");
        System.out.println("  java jsdai.tools.CompareAttributes ignore.txt ap210_arm ap210_xim");
    }

    public static void main(String[] args) throws SdaiException {
        if (args.length != 3 && args.length != 4) {
            CompareAttributes.printUsage();
            return;
        }
        String ignoreFile = args[0];
        String armSchemaName = args[1];
        String ximSchemaName = args[2];
        boolean skipDerived = false;
        if (args.length == 4) {
            skipDerived = true;
        }
        String repoName = "ExpressCompilerRepo";
        System.out.println("Initializing JSDAI...");
        SdaiRepository repo = CompareUsefroms.getRepository(repoName);
        if (repo == null) {
            System.err.println("Unable to open repo: " + repoName);
            return;
        }
        ASdaiModel models = SearchForRedundantUsefroms.activateModels((SdaiRepository)repo);
        Map schemas = CompareUsefroms.enumSchemas(models);
        if (!schemas.containsKey(armSchemaName)) {
            System.err.println("Specified ARM schema was not found: " + armSchemaName);
            return;
        }
        if (!schemas.containsKey(ximSchemaName)) {
            System.err.println("Specified XIM schema was not found: " + ximSchemaName);
            return;
        }
        System.out.println("Retrieving ARM schemas...");
        HashSet armSchemas = new HashSet();
        CompareAttributes.enumReferencedSchemas(models, armSchemaName, schemas, armSchemas);
        System.out.println("Retrieving ARM entities...");
        Map armEntities = CompareAttributes.enumEntities(armSchemas, schemas);
        System.out.println("Retrieving XIM schemas...");
        HashSet ximSchemas = new HashSet();
        CompareAttributes.enumReferencedSchemas(models, ximSchemaName, schemas, ximSchemas);
        System.out.println("Retrieving XIM entities...");
        Map ximEntities = CompareAttributes.enumEntities(ximSchemas, schemas);
        Map ignoreMap = CompareAttributes.getIgnoreMap(ignoreFile);
        Pattern armxPattern = Pattern.compile("(\\w+)_armx");
        Pattern doubleUndescorePattern = Pattern.compile("(\\w+)__\\w+");
        for (String ximEntity : ximEntities.keySet()) {
            EEntity_definition ximEd;
            ESchema_definition ximSchema;
            if (ximEntity.indexOf("__") >= 0 || !(ximSchema = (ESchema_definition)(ximEd = (EEntity_definition)ximEntities.get(ximEntity)).getTemp(SCHEMA_KEY)).getName(null).endsWith("_XIM")) continue;
            Matcher m = armxPattern.matcher(ximEntity);
            String armEntity = m.find() ? m.group(1) : ((m = doubleUndescorePattern.matcher(ximEntity)).find() ? m.group(1) : ximEntity);
            EEntity_definition armEd = (EEntity_definition)armEntities.get(armEntity);
            if (armEd == null) {
                System.err.println("Unable to find ARM entity for XIM entity: " + ximEntity);
                continue;
            }
            Map ximAttrs = CompareAttributes.getAttributes(models, ximEd, new HashSet());
            Map armAttrs = CompareAttributes.getAttributes(models, armEd, new HashSet());
            for (String armAttr : armAttrs.keySet()) {
                EAttribute eAttr = (EAttribute)armAttrs.get(armAttr);
                String parent = (eAttr = CompareAttributes.getRootAttribute(eAttr)).getParent(null).getName(null);
                Set ignore = (Set)ignoreMap.get(parent);
                if (ignore != null && ignore.contains(eAttr.getName(null)) || ximAttrs.containsKey(armAttr) || ximAttrs.containsKey(armAttr + "_x")) continue;
                System.out.println("XIM entity " + ximEntity + " has no attribute " + armAttr);
            }
            if (CompareAttributes.skip(ximEd)) continue;
            boolean displayHead = true;
            for (String ximAttr : ximAttrs.keySet()) {
                String name = ximAttr;
                if (name.endsWith("_x")) {
                    name = name.substring(0, name.length() - 2);
                }
                if (armAttrs.containsKey(name)) continue;
                EAttribute eXimAttr = (EAttribute)ximAttrs.get(ximAttr);
                EEntity_or_view_definition eParent = eXimAttr.getParent(null);
                if (eXimAttr instanceof EDerived_attribute) continue;
                String out = "";
                if (eParent != ximEd) {
                    EEntity eDomain;
                    if (skipDerived) continue;
                    if (displayHead) {
                        System.out.println("============ Entity " + ximSchema.getName(null) + "." + ximEntity);
                        displayHead = false;
                    }
                    out = "SELF\\" + eParent.getName(null) + "." + ximAttr + " : ";
                    if (eXimAttr instanceof EExplicit_attribute && (eDomain = ((EExplicit_attribute)eXimAttr).getDomain(null)) instanceof ENamed_type) {
                        out = out + ((ENamed_type)eDomain).getName(null);
                    }
                    out = out + " := ?;";
                } else {
                    out = "Unexpected attribute " + ximEntity + "." + ximAttr;
                }
                System.out.println(out);
            }
        }
        System.out.println("Done.");
    }
}

