/*
 * Decompiled with CFR 0.152.
 */
package jsdai.tools;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jsdai.SExtended_dictionary_schema.AUse_from_specification;
import jsdai.SExtended_dictionary_schema.CUse_from_specification;
import jsdai.SExtended_dictionary_schema.EGeneric_schema_definition;
import jsdai.SExtended_dictionary_schema.ESchema_definition;
import jsdai.SExtended_dictionary_schema.EUse_from_specification;
import jsdai.lang.AEntity;
import jsdai.lang.ASdaiModel;
import jsdai.lang.ASdaiRepository;
import jsdai.lang.SdaiContext;
import jsdai.lang.SdaiException;
import jsdai.lang.SdaiIterator;
import jsdai.lang.SdaiRepository;
import jsdai.lang.SdaiSession;
import jsdai.tools.SearchForRedundantUsefroms;

public final class CompareUsefroms {
    private static final Set SCHEMA_TYPES = new HashSet<String>(Arrays.asList("_MIM", "_ARM", "_XIM"));

    private CompareUsefroms() {
    }

    static Set enumAllUsefroms(ASdaiModel domain, ESchema_definition schema) throws SdaiException {
        HashSet<String> result = new HashSet<String>();
        AUse_from_specification aUsefroms = new AUse_from_specification();
        CUse_from_specification.usedinCurrent_schema(null, (EGeneric_schema_definition)schema, (ASdaiModel)domain, (AEntity)aUsefroms);
        SdaiIterator i = aUsefroms.createIterator();
        while (i.next()) {
            EUse_from_specification eUsefrom = aUsefroms.getCurrentMember(i);
            EGeneric_schema_definition foreignSchema = eUsefrom.getForeign_schema(null);
            String foreignName = foreignSchema.getName(null);
            result.add(foreignName);
        }
        return result;
    }

    public static SdaiRepository getRepository(String repoName) throws SdaiException {
        SdaiSession session = SdaiSession.openSession();
        session.setSdaiContext(new SdaiContext());
        session.startTransactionReadWriteAccess();
        ASdaiRepository arep = session.getKnownServers();
        SdaiRepository repo = null;
        SdaiIterator i = arep.createIterator();
        while (i.next()) {
            repo = arep.getCurrentMember(i);
            if (!repo.getName().equals(repoName)) continue;
            repo.openRepository();
            break;
        }
        return repo;
    }

    public static Map enumSchemas(ASdaiModel models) throws SdaiException {
        AEntity aSchemas = models.getInstances(ESchema_definition.class);
        HashMap<String, ESchema_definition> schemas = new HashMap<String, ESchema_definition>();
        SdaiIterator i = aSchemas.createIterator();
        while (i.next()) {
            ESchema_definition schema = (ESchema_definition)aSchemas.getCurrentMemberEntity(i);
            String schemaName = schema.getName(null);
            schemas.put(schemaName, schema);
        }
        return schemas;
    }

    public static void main(String[] args) throws SdaiException {
        if (args.length != 2) {
            System.out.println("Invalid usage. Should be:");
            System.out.println("  java jsdai.tools.CompareUsefroms schemasType1 schemasType2");
            System.out.println("    schemasType1: the first type of schemas to compare (_MIM, _ARM, _XIM)");
            System.out.println("    schemasType2: the second type of schemas to compare (_MIM, _ARM, _XIM)");
            System.out.println("Note:");
            System.out.println("  Schemas types are case sensitive.");
            System.out.println("Example:");
            System.out.println("  java jsdai.tools.CompareUsefroms _ARM _XIM");
            return;
        }
        String schemasType1 = args[0];
        if (!SCHEMA_TYPES.contains(schemasType1)) {
            System.out.println("The first schemas type is invalid: " + schemasType1);
            return;
        }
        String schemasType2 = args[1];
        if (!SCHEMA_TYPES.contains(schemasType2)) {
            System.out.println("The second schemas type is invalid: " + schemasType2);
            return;
        }
        System.out.println("Initializing JSDAI...");
        SdaiRepository repo = CompareUsefroms.getRepository("ExpressCompilerRepo");
        if (repo == null) {
            System.out.println("Unable to init Jsdai.");
            return;
        }
        System.out.println("Activating models...");
        ASdaiModel models = SearchForRedundantUsefroms.activateModels((SdaiRepository)repo);
        System.out.println("Enumerating schemas...");
        Map schemas = CompareUsefroms.enumSchemas(models);
        System.out.println("Type1: " + schemasType1);
        System.out.println("Type2: " + schemasType2);
        for (String type1SchemaName : schemas.keySet()) {
            if (!type1SchemaName.endsWith(schemasType1)) continue;
            String type2SchemaName = type1SchemaName.replaceAll(schemasType1, schemasType2);
            ESchema_definition type2Schema = (ESchema_definition)schemas.get(type2SchemaName);
            if (type2Schema == null) {
                System.err.println("Unable to find " + schemasType2 + " schema " + type2SchemaName);
                continue;
            }
            ESchema_definition type1Schema = (ESchema_definition)schemas.get(type1SchemaName);
            Set type1Usefroms = CompareUsefroms.enumAllUsefroms(models, type1Schema);
            Set type2Usefroms = CompareUsefroms.enumAllUsefroms(models, type2Schema);
            for (String type1Usefrom : type1Usefroms) {
                String type2Usefrom;
                if (!type1Usefrom.endsWith(schemasType1) || type2Usefroms.contains(type2Usefrom = type1Usefrom.replaceAll(schemasType1, schemasType2))) continue;
                System.err.println(type2SchemaName + ": the usefrom " + type2Usefrom + " was not found.");
            }
            for (String type2Usefrom : type2Usefroms) {
                String type1Usefrom;
                if (!type2Usefrom.endsWith(schemasType2) || type1Usefroms.contains(type1Usefrom = type2Usefrom.replaceAll(schemasType2, schemasType1))) continue;
                System.err.println(type1SchemaName + ": the usefrom " + type1Usefrom + " was not found.");
            }
        }
        SdaiSession.getSession().closeSession();
    }
}

