/*
 * Decompiled with CFR 0.152.
 */
package jsdai.tools;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import jsdai.SExtended_dictionary_schema.AAttribute;
import jsdai.SExtended_dictionary_schema.AEntity_definition;
import jsdai.SExtended_dictionary_schema.AEntity_or_view_or_subtype_expression;
import jsdai.SExtended_dictionary_schema.AInterfaced_declaration;
import jsdai.SExtended_dictionary_schema.ANamed_type;
import jsdai.SExtended_dictionary_schema.AParameter;
import jsdai.SExtended_dictionary_schema.ASub_supertype_constraint;
import jsdai.SExtended_dictionary_schema.AUniqueness_rule;
import jsdai.SExtended_dictionary_schema.AWhere_rule;
import jsdai.SExtended_dictionary_schema.CSub_supertype_constraint;
import jsdai.SExtended_dictionary_schema.EAggregation_type;
import jsdai.SExtended_dictionary_schema.EAlgorithm_definition;
import jsdai.SExtended_dictionary_schema.EAnd_subtype_expression;
import jsdai.SExtended_dictionary_schema.EAndor_subtype_expression;
import jsdai.SExtended_dictionary_schema.EArray_type;
import jsdai.SExtended_dictionary_schema.EAttribute;
import jsdai.SExtended_dictionary_schema.EBag_type;
import jsdai.SExtended_dictionary_schema.EBinary_type;
import jsdai.SExtended_dictionary_schema.EBoolean_type;
import jsdai.SExtended_dictionary_schema.EBound;
import jsdai.SExtended_dictionary_schema.EConstant_definition;
import jsdai.SExtended_dictionary_schema.EData_type;
import jsdai.SExtended_dictionary_schema.EDeclaration;
import jsdai.SExtended_dictionary_schema.EDefined_type;
import jsdai.SExtended_dictionary_schema.EDerived_attribute;
import jsdai.SExtended_dictionary_schema.EEntity_definition;
import jsdai.SExtended_dictionary_schema.EEntity_or_view_definition;
import jsdai.SExtended_dictionary_schema.EEntity_select_type;
import jsdai.SExtended_dictionary_schema.EEnumeration_type;
import jsdai.SExtended_dictionary_schema.EExplicit_attribute;
import jsdai.SExtended_dictionary_schema.EExpress_code;
import jsdai.SExtended_dictionary_schema.EExtended_enumeration_type;
import jsdai.SExtended_dictionary_schema.EExtended_select_type;
import jsdai.SExtended_dictionary_schema.EExtensible_enumeration_type;
import jsdai.SExtended_dictionary_schema.EExtensible_select_type;
import jsdai.SExtended_dictionary_schema.EFunction_definition;
import jsdai.SExtended_dictionary_schema.EGlobal_rule;
import jsdai.SExtended_dictionary_schema.EImplicit_declaration;
import jsdai.SExtended_dictionary_schema.EInteger_type;
import jsdai.SExtended_dictionary_schema.EInterface_specification;
import jsdai.SExtended_dictionary_schema.EInterfaced_declaration;
import jsdai.SExtended_dictionary_schema.EInverse_attribute;
import jsdai.SExtended_dictionary_schema.EList_type;
import jsdai.SExtended_dictionary_schema.ELogical_type;
import jsdai.SExtended_dictionary_schema.ENumber_type;
import jsdai.SExtended_dictionary_schema.EOneof_subtype_expression;
import jsdai.SExtended_dictionary_schema.EParameter;
import jsdai.SExtended_dictionary_schema.EProcedure_definition;
import jsdai.SExtended_dictionary_schema.EReal_type;
import jsdai.SExtended_dictionary_schema.EReference_from_specification;
import jsdai.SExtended_dictionary_schema.ESelect_type;
import jsdai.SExtended_dictionary_schema.ESet_type;
import jsdai.SExtended_dictionary_schema.ESimple_type;
import jsdai.SExtended_dictionary_schema.EString_type;
import jsdai.SExtended_dictionary_schema.ESub_supertype_constraint;
import jsdai.SExtended_dictionary_schema.ESubtype_expression;
import jsdai.SExtended_dictionary_schema.EUniqueness_rule;
import jsdai.SExtended_dictionary_schema.EUse_from_specification;
import jsdai.SExtended_dictionary_schema.EVariable_size_aggregation_type;
import jsdai.SExtended_dictionary_schema.EWhere_rule;
import jsdai.SExtended_dictionary_schema.SExtended_dictionary_schema;
import jsdai.dictionary.ESchema_definition;
import jsdai.lang.AEntity;
import jsdai.lang.ASdaiModel;
import jsdai.lang.A_string;
import jsdai.lang.EEntity;
import jsdai.lang.SchemaInstance;
import jsdai.lang.SdaiContext;
import jsdai.lang.SdaiException;
import jsdai.lang.SdaiIterator;
import jsdai.lang.SdaiModel;
import jsdai.lang.SdaiRepository;
import jsdai.lang.SdaiSession;
import jsdai.tools.Utils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public class ExpressXmlConverter {
    public static boolean validate = true;
    public static String moduleLocation = "c:/stepmod_modules/stepmod/data/modules/";
    static final String STYLESHEET_TARGET = "xml-stylesheet";
    static final String STYLESHEET_DATA = "type=\"text/xsl\" href=\"../../../xsl/express.xsl\"";
    static final String EXPRESS_MOD_PREFIX = "_EXPRESS_";
    static final String DICT_MOD_SUFIX = "_DICTIONARY_DATA";
    static final String LANGUAGE_VERSION = "2";
    static final String VAR_PARAMETER = "VAR ";
    static final String MIM_SCHEMA = "_mim";
    static final int MIM_SUFFIX_LENGTH = "_mim".length();

    private ExpressXmlConverter() {
    }

    public static void main(String[] args) {
    }

    public static void convertSchemaInstance(SchemaInstance sch_inst, String file_name) throws SdaiException {
        SdaiRepository repo = sch_inst.getRepository();
        SdaiModel work = repo.createSdaiModel("working", SExtended_dictionary_schema.class);
        SdaiSession session = repo.getSession();
        String searched_name = sch_inst.getName().toUpperCase() + DICT_MOD_SUFIX;
        ASdaiModel assoc_mods = sch_inst.getAssociatedModels();
        SdaiIterator iter_assoc = assoc_mods.createIterator();
        SdaiModel model = null;
        while (iter_assoc.next()) {
            SdaiModel mod = assoc_mods.getCurrentMember(iter_assoc);
            if (!mod.getName().equals(searched_name)) continue;
            model = mod;
            break;
        }
        if (model != null) {
            if (model.getMode() == 0) {
                model.startReadOnlyAccess();
            }
        } else {
            throw new SdaiException(1000);
        }
        ExpressXmlConverter.convertModel(model, session, repo, work, file_name);
        work.deleteSdaiModel();
    }

    private static void convertModel(SdaiModel model, SdaiSession session, SdaiRepository repo, SdaiModel work, String file_name) throws SdaiException {
        String sup_expression;
        EEntity_definition def;
        int i;
        EDeclaration decl;
        SdaiIterator iter;
        jsdai.SExtended_dictionary_schema.ESchema_definition inter_schema;
        String suffix;
        EWhere_rule[] wh_rules = null;
        EUniqueness_rule[] un_rules = null;
        Document doc = null;
        try {
            DocumentBuilderFactory f = DocumentBuilderFactory.newInstance();
            f.setValidating(validate);
            if (validate) {
                f.setIgnoringElementContentWhitespace(true);
                f.setIgnoringComments(true);
            }
            f.setCoalescing(true);
            DocumentBuilder builder = f.newDocumentBuilder();
            builder.setErrorHandler(new MyErrorHandler());
            doc = builder.newDocument();
        }
        catch (ParserConfigurationException e) {
            System.out.println("PROBLEM: " + e.getMessage());
            e.printStackTrace();
        }
        ProcessingInstruction style_sheet = doc.createProcessingInstruction(STYLESHEET_TARGET, STYLESHEET_DATA);
        doc.appendChild(style_sheet);
        ASub_supertype_constraint subtypes = null;
        ESchema_definition a_schema = work.getUnderlyingSchema();
        ASdaiModel domain = new ASdaiModel();
        domain.addByIndex(1, model);
        SdaiContext context = new SdaiContext(a_schema, domain, work);
        session.setSdaiContext(context);
        String mod_name = model.getName();
        ESchema_definition und_schema = model.getUnderlyingSchema();
        jsdai.dictionary.EEntity_definition sch_def_def = und_schema.getEntityDefinition("schema_definition");
        AEntity sch_defs = model.getExactInstances(sch_def_def);
        jsdai.SExtended_dictionary_schema.ESchema_definition schema_def = (jsdai.SExtended_dictionary_schema.ESchema_definition)sch_defs.getByIndexEntity(1);
        String schema_name = schema_def.getName(null);
        String xpr_model_name = EXPRESS_MOD_PREFIX + schema_name.toUpperCase();
        SdaiModel xpr_model = repo.findSdaiModel(xpr_model_name);
        if (xpr_model != null && xpr_model.getMode() == 0) {
            xpr_model.startReadOnlyAccess();
        }
        Element root = doc.createElement("express");
        Attr atr = doc.createAttribute("language_version");
        atr.setValue(LANGUAGE_VERSION);
        root.setAttributeNode(atr);
        atr = doc.createAttribute("rcs.date");
        String aux_str = "$Date$";
        atr.setValue(aux_str);
        root.setAttributeNode(atr);
        atr = doc.createAttribute("rcs.revision");
        aux_str = "$Revision$";
        atr.setValue(aux_str);
        root.setAttributeNode(atr);
        atr = doc.createAttribute("description.file");
        int sch_nm_ln = schema_name.length();
        String description_type = sch_nm_ln >= MIM_SUFFIX_LENGTH ? ((suffix = schema_name.substring(sch_nm_ln - MIM_SUFFIX_LENGTH)).equals(MIM_SCHEMA) ? "mim_descriptions.xml" : "arm_descriptions.xml") : "arm_descriptions.xml";
        atr.setValue(description_type);
        root.setAttributeNode(atr);
        Element appl_elem = doc.createElement("application");
        root.appendChild(appl_elem);
        atr = doc.createAttribute("name");
        atr.setValue("JSDAI");
        appl_elem.setAttributeNode(atr);
        atr = doc.createAttribute("owner");
        atr.setValue("LKSoft");
        appl_elem.setAttributeNode(atr);
        atr = doc.createAttribute("url");
        atr.setValue("www.lksoft.com");
        appl_elem.setAttributeNode(atr);
        atr = doc.createAttribute("version");
        atr.setValue("4.0 beta");
        appl_elem.setAttributeNode(atr);
        atr = doc.createAttribute("source");
        atr.setValue(schema_name.toLowerCase() + " schema_instance");
        appl_elem.setAttributeNode(atr);
        Element sch_elem = doc.createElement("schema");
        atr = doc.createAttribute("name");
        atr.setValue(schema_name);
        sch_elem.setAttributeNode(atr);
        if (und_schema.testIdentification(null)) {
            atr = doc.createAttribute("version");
            atr.setValue(und_schema.getIdentification(null));
            sch_elem.setAttributeNode(atr);
        }
        jsdai.dictionary.EEntity_definition xpr_code_def = und_schema.getEntityDefinition("express_code");
        AEntity xpr_code_aggr = null;
        if (xpr_model != null) {
            xpr_code_aggr = xpr_model.getInstances(xpr_code_def);
        }
        jsdai.dictionary.EEntity_definition ref_spec_def = und_schema.getEntityDefinition("reference_from_specification");
        AEntity ref_specs = model.getExactInstances(ref_spec_def);
        jsdai.dictionary.EEntity_definition use_spec_def = und_schema.getEntityDefinition("use_from_specification");
        AEntity use_specs = model.getExactInstances(use_spec_def);
        jsdai.dictionary.EEntity_definition inter_spec_def = und_schema.getEntityDefinition("interface_specification");
        AEntity inter_specs = model.getExactInstances(inter_spec_def);
        SdaiIterator iter_auxil = null;
        SdaiIterator iter_auxil2 = null;
        SdaiIterator iter_specs = null;
        if (use_specs.getMemberCount() > 0) {
            if (iter_specs == null) {
                iter_specs = use_specs.createIterator();
            }
            while (iter_specs.next()) {
                EUse_from_specification use_spec = (EUse_from_specification)use_specs.getCurrentMemberEntity(iter_specs);
                Element inter_use_elem = doc.createElement("interface");
                sch_elem.appendChild(inter_use_elem);
                atr = doc.createAttribute("kind");
                atr.setValue("use");
                inter_use_elem.setAttributeNode(atr);
                atr = doc.createAttribute("schema");
                inter_schema = (jsdai.SExtended_dictionary_schema.ESchema_definition)use_spec.getForeign_schema(null);
                atr.setValue(ExpressXmlConverter.getCorrectedName(inter_schema));
                inter_use_elem.setAttributeNode(atr);
                if (!use_spec.testItems(null) || (iter = ExpressXmlConverter.convertInterfacedItems(use_spec.getItems(null), iter_auxil, inter_use_elem, doc)) == null) continue;
                iter_auxil = iter;
            }
        }
        if (ref_specs.getMemberCount() > 0) {
            if (iter_specs == null) {
                iter_specs = ref_specs.createIterator();
            } else {
                ref_specs.attachIterator(iter_specs);
            }
            while (iter_specs.next()) {
                EReference_from_specification ref_spec = (EReference_from_specification)ref_specs.getCurrentMemberEntity(iter_specs);
                Element inter_ref_elem = doc.createElement("interface");
                sch_elem.appendChild(inter_ref_elem);
                atr = doc.createAttribute("kind");
                atr.setValue("reference");
                inter_ref_elem.setAttributeNode(atr);
                atr = doc.createAttribute("schema");
                inter_schema = (jsdai.SExtended_dictionary_schema.ESchema_definition)ref_spec.getForeign_schema(null);
                atr.setValue(ExpressXmlConverter.getCorrectedName(inter_schema));
                inter_ref_elem.setAttributeNode(atr);
                if (!ref_spec.testItems(null) || (iter = ExpressXmlConverter.convertInterfacedItems(ref_spec.getItems(null), iter_auxil, inter_ref_elem, doc)) == null) continue;
                iter_auxil = iter;
            }
        }
        if (inter_specs.getMemberCount() > 0) {
            if (iter_specs == null) {
                iter_specs = inter_specs.createIterator();
            } else {
                inter_specs.attachIterator(iter_specs);
            }
            while (iter_specs.next()) {
                EInterface_specification inter_spec = (EInterface_specification)inter_specs.getCurrentMemberEntity(iter_specs);
                Element inter_elem = doc.createElement("interface");
                sch_elem.appendChild(inter_elem);
                atr = doc.createAttribute("schema");
                inter_schema = (jsdai.SExtended_dictionary_schema.ESchema_definition)inter_spec.getForeign_schema(null);
                atr.setValue(ExpressXmlConverter.getCorrectedName(inter_schema));
                inter_elem.setAttributeNode(atr);
                if (!inter_spec.testItems(null) || (iter = ExpressXmlConverter.convertInterfacedItems(inter_spec.getItems(null), iter_auxil, inter_elem, doc)) == null) continue;
                iter_auxil = iter;
            }
        }
        jsdai.dictionary.EEntity_definition const_loc_decls_def = und_schema.getEntityDefinition("constant_declaration+local_declaration");
        AEntity const_decls = model.getInstances(const_loc_decls_def);
        SdaiIterator iter_const_decls = const_decls.createIterator();
        while (iter_const_decls.next()) {
            decl = (EDeclaration)const_decls.getCurrentMemberEntity(iter_const_decls);
            EConstant_definition const_def = (EConstant_definition)decl.getDefinition(null);
            Element const_elem = doc.createElement("constant");
            sch_elem.appendChild(const_elem);
            atr = doc.createAttribute("name");
            atr.setValue(const_def.getName(null));
            const_elem.setAttributeNode(atr);
            if (xpr_code_aggr != null && (iter = ExpressXmlConverter.takeExpression(xpr_code_aggr, (EEntity)const_def, iter_auxil, const_elem, "expression", doc)) != null) {
                iter_auxil = iter;
            }
            ExpressXmlConverter.convertUnderType((EData_type)const_def.getDomain(null), const_elem, doc, null, 0);
        }
        jsdai.dictionary.EEntity_definition def_type_def = und_schema.getEntityDefinition("defined_type");
        AEntity def_types = model.getInstances(def_type_def);
        int dt_count = 0;
        EDefined_type[] defin_types = new EDefined_type[def_types.getMemberCount()];
        SdaiIterator iter_def_types = def_types.createIterator();
        while (iter_def_types.next()) {
            defin_types[dt_count++] = (EDefined_type)def_types.getCurrentMemberEntity(iter_def_types);
        }
        Arrays.sort(defin_types, new SorterForTypes());
        for (i = 0; i < dt_count; ++i) {
            EDefined_type def_type = defin_types[i];
            Element def_type_elem = doc.createElement("type");
            sch_elem.appendChild(def_type_elem);
            atr = doc.createAttribute("name");
            atr.setValue(def_type.getName(null));
            def_type_elem.setAttributeNode(atr);
            ExpressXmlConverter.convertDefType((EData_type)def_type.getDomain(null), def_type_elem, doc);
            if (xpr_code_aggr == null || (iter = ExpressXmlConverter.convertWhereRules(def_type.getWhere_rules(null, null), wh_rules, xpr_code_aggr, iter_auxil, iter_auxil2, def_type_elem, doc)) == null) continue;
            iter_auxil = iter;
        }
        jsdai.dictionary.EEntity_definition ent_loc_decls_def = und_schema.getEntityDefinition("entity_declaration+local_declaration");
        AEntity decls = model.getInstances(ent_loc_decls_def);
        int e_count = 0;
        EEntity_definition[] entities = new EEntity_definition[decls.getMemberCount()];
        EAttribute[] attribs = null;
        SdaiIterator iter_decls = decls.createIterator();
        while (iter_decls.next()) {
            decl = (EDeclaration)decls.getCurrentMemberEntity(iter_decls);
            def = (EEntity_definition)decl.getDefinition(null);
            if (def.getComplex(null)) continue;
            entities[e_count++] = def;
        }
        Arrays.sort(entities, 0, e_count, new SorterForEntities());
        for (i = 0; i < e_count; ++i) {
            EAttribute ent_at;
            int j;
            AEntity_definition supertypes;
            def = entities[i];
            Element entity_elem = doc.createElement("entity");
            sch_elem.appendChild(entity_elem);
            atr = doc.createAttribute("name");
            atr.setValue(ExpressXmlConverter.getCorrectedName((EData_type)def));
            entity_elem.setAttributeNode(atr);
            if (def.testAbstract_entity(null) && def.getAbstract_entity(null)) {
                atr = doc.createAttribute("abstract.entity");
                atr.setValue("YES");
                entity_elem.setAttributeNode(atr);
            }
            if (!def.getInstantiable(null)) {
                atr = doc.createAttribute("abstract.supertype");
                atr.setValue("YES");
                entity_elem.setAttributeNode(atr);
            }
            if ((supertypes = def.getSupertypes(null)).getMemberCount() > 0) {
                if (iter_auxil == null) {
                    iter_auxil = supertypes.createIterator();
                } else {
                    supertypes.attachIterator(iter_auxil);
                }
                atr = doc.createAttribute("supertypes");
                String s_types = "";
                int count = 0;
                while (iter_auxil.next()) {
                    EEntity_definition supertype = (EEntity_definition)supertypes.getCurrentMemberEntity(iter_auxil);
                    if (++count > 1) {
                        s_types = s_types + " ";
                    }
                    s_types = s_types + ExpressXmlConverter.getCorrectedName((EData_type)supertype);
                }
                atr.setValue(s_types);
                entity_elem.setAttributeNode(atr);
            }
            if (!(sup_expression = ExpressXmlConverter.convertSuperExpression(def, iter_auxil, subtypes)).equals("")) {
                atr = doc.createAttribute("super.expression");
                atr.setValue(sup_expression);
                entity_elem.setAttributeNode(atr);
            }
            AAttribute ent_attrs = def.getAttributes(null, null);
            int ln = ent_attrs.getMemberCount();
            if (attribs == null || ln > attribs.length) {
                attribs = new EAttribute[ln];
            }
            if (iter_auxil == null) {
                iter_auxil = ent_attrs.createIterator();
            } else {
                ent_attrs.attachIterator(iter_auxil);
            }
            int attr_count = 0;
            while (iter_auxil.next()) {
                attribs[attr_count++] = (EAttribute)ent_attrs.getCurrentMemberEntity(iter_auxil);
            }
            for (j = 0; j < attr_count / 2; ++j) {
                ent_at = attribs[j];
                attribs[j] = attribs[attr_count - j - 1];
                attribs[attr_count - j - 1] = ent_at;
            }
            for (j = 0; j < attr_count; ++j) {
                ent_at = attribs[j];
                if (!(ent_at instanceof EExplicit_attribute)) continue;
                ExpressXmlConverter.convertExplicitAttribute((EExplicit_attribute)ent_at, entity_elem, doc);
            }
            for (j = 0; j < attr_count; ++j) {
                ent_at = attribs[j];
                if (!(ent_at instanceof EDerived_attribute) || (iter = ExpressXmlConverter.convertDerivedAttribute((EDerived_attribute)ent_at, xpr_code_aggr, iter_auxil2, entity_elem, doc)) == null) continue;
                iter_auxil2 = iter;
            }
            for (j = 0; j < attr_count; ++j) {
                ent_at = attribs[j];
                if (!(ent_at instanceof EInverse_attribute)) continue;
                ExpressXmlConverter.convertInverseAttribute((EInverse_attribute)ent_at, entity_elem, doc);
            }
            iter = ExpressXmlConverter.convertUniquenessRules(def.getUniqueness_rules(null, null), un_rules, iter_auxil, entity_elem, doc);
            if (iter != null) {
                iter_auxil = iter;
            }
            if (xpr_code_aggr == null || (iter = ExpressXmlConverter.convertWhereRules(def.getWhere_rules(null, null), wh_rules, xpr_code_aggr, iter_auxil, iter_auxil2, entity_elem, doc)) == null) continue;
            iter_auxil = iter;
        }
        jsdai.dictionary.EEntity_definition subt_constr_decls_def = und_schema.getEntityDefinition("local_declaration+subtype_constraint_declaration");
        AEntity subt_constr_decls = model.getInstances(subt_constr_decls_def);
        SdaiIterator iter_subt_constr_decls = subt_constr_decls.createIterator();
        while (iter_subt_constr_decls.next()) {
            ESubtype_expression expression;
            decl = (EDeclaration)subt_constr_decls.getCurrentMemberEntity(iter_subt_constr_decls);
            ESub_supertype_constraint subt_constr = (ESub_supertype_constraint)decl.getDefinition(null);
            Element subt_constr_elem = doc.createElement("subtype.constraint");
            sch_elem.appendChild(subt_constr_elem);
            atr = doc.createAttribute("name");
            atr.setValue(subt_constr.getName(null));
            subt_constr_elem.setAttributeNode(atr);
            atr = doc.createAttribute("entity");
            atr.setValue(ExpressXmlConverter.getCorrectedName((EData_type)subt_constr.getGeneric_supertype(null)));
            subt_constr_elem.setAttributeNode(atr);
            if (subt_constr.testAbstract_supertype(null) && subt_constr.getAbstract_supertype(null)) {
                atr = doc.createAttribute("abstract.supertype");
                atr.setValue("YES");
                subt_constr_elem.setAttributeNode(atr);
            }
            if (subt_constr.testTotal_cover(null) && (iter = ExpressXmlConverter.convertEntitiesAggr(subt_constr.getTotal_cover(null), "totalover", iter_auxil, subt_constr_elem, doc)) != null) {
                iter_auxil = iter;
            }
            if (!subt_constr.testConstraint(null) || (expression = subt_constr.getConstraint(null)) == null || (sup_expression = ExpressXmlConverter.convertSubtypeConstraint(expression)).equals("")) continue;
            atr = doc.createAttribute("super.expression");
            atr.setValue(sup_expression);
            subt_constr_elem.setAttributeNode(atr);
        }
        jsdai.dictionary.EEntity_definition rule_decls_def = und_schema.getEntityDefinition("local_declaration+rule_declaration");
        AEntity rule_decls = model.getInstances(rule_decls_def);
        int r_count = 0;
        EGlobal_rule[] rules = new EGlobal_rule[rule_decls.getMemberCount()];
        SdaiIterator iter_rule_decls = rule_decls.createIterator();
        while (iter_rule_decls.next()) {
            decl = (EDeclaration)rule_decls.getCurrentMemberEntity(iter_rule_decls);
            rules[r_count++] = (EGlobal_rule)decl.getDefinition(null);
        }
        Arrays.sort(rules, new SorterForRules());
        for (i = 0; i < r_count; ++i) {
            EGlobal_rule glob_rule = rules[i];
            Element rule_elem = doc.createElement("rule");
            sch_elem.appendChild(rule_elem);
            atr = doc.createAttribute("name");
            atr.setValue(ExpressXmlConverter.getCorrectedName(glob_rule));
            rule_elem.setAttributeNode(atr);
            iter = ExpressXmlConverter.convertEntitiesAggr(glob_rule.getEntities(null), "appliesto", iter_auxil, rule_elem, doc);
            if (iter != null) {
                iter_auxil = iter;
            }
            if (xpr_code_aggr == null) continue;
            iter = ExpressXmlConverter.convertAlgorithm(xpr_code_aggr, (EEntity)glob_rule, iter_auxil, rule_elem, doc);
            if (iter != null) {
                iter_auxil = iter;
            }
            if ((iter = ExpressXmlConverter.convertWhereRules(glob_rule.getWhere_rules(null, null), wh_rules, xpr_code_aggr, iter_auxil, iter_auxil2, rule_elem, doc)) == null) continue;
            iter_auxil = iter;
        }
        jsdai.dictionary.EEntity_definition funct_decls_def = und_schema.getEntityDefinition("function_declaration+local_declaration");
        AEntity funct_decls = model.getInstances(funct_decls_def);
        int f_count = 0;
        EFunction_definition[] functions = new EFunction_definition[funct_decls.getMemberCount()];
        SdaiIterator iter_funct_decls = funct_decls.createIterator();
        while (iter_funct_decls.next()) {
            decl = (EDeclaration)funct_decls.getCurrentMemberEntity(iter_funct_decls);
            functions[f_count++] = (EFunction_definition)decl.getDefinition(null);
        }
        Arrays.sort(functions, new SorterForFunctions());
        for (i = 0; i < f_count; ++i) {
            EFunction_definition funct_def = functions[i];
            Element funct_elem = doc.createElement("function");
            sch_elem.appendChild(funct_elem);
            atr = doc.createAttribute("name");
            atr.setValue(ExpressXmlConverter.getCorrectedName(funct_def));
            funct_elem.setAttributeNode(atr);
            iter = ExpressXmlConverter.convertParameters(funct_def.getParameters(null), iter_auxil, funct_elem, doc);
            if (iter != null) {
                iter_auxil = iter;
            }
            if (funct_def.testReturn_type_label(null)) {
                ExpressXmlConverter.convertUnderType(funct_def.getReturn_type(null), funct_elem, doc, funct_def.getReturn_type_label(null), 0);
            } else {
                ExpressXmlConverter.convertUnderType(funct_def.getReturn_type(null), funct_elem, doc, null, 0);
            }
            if (xpr_code_aggr == null || (iter = ExpressXmlConverter.convertAlgorithm(xpr_code_aggr, (EEntity)funct_def, iter_auxil, funct_elem, doc)) == null) continue;
            iter_auxil = iter;
        }
        jsdai.dictionary.EEntity_definition proc_decls_def = und_schema.getEntityDefinition("local_declaration+procedure_declaration");
        AEntity proc_decls = model.getInstances(proc_decls_def);
        SdaiIterator iter_proc_decls = proc_decls.createIterator();
        while (iter_proc_decls.next()) {
            decl = (EDeclaration)proc_decls.getCurrentMemberEntity(iter_proc_decls);
            EProcedure_definition proc_def = (EProcedure_definition)decl.getDefinition(null);
            Element proc_elem = doc.createElement("procedure");
            sch_elem.appendChild(proc_elem);
            atr = doc.createAttribute("name");
            atr.setValue(ExpressXmlConverter.getCorrectedName(proc_def));
            proc_elem.setAttributeNode(atr);
            iter = ExpressXmlConverter.convertParameters(proc_def.getParameters(null), iter_auxil, proc_elem, doc);
            if (iter != null) {
                iter_auxil = iter;
            }
            if (xpr_code_aggr == null || (iter = ExpressXmlConverter.convertAlgorithm(xpr_code_aggr, (EEntity)proc_def, iter_auxil, proc_elem, doc)) == null) continue;
            iter_auxil = iter;
        }
        root.appendChild(sch_elem);
        doc.appendChild(root);
        try {
            Utils.saveToFile(file_name, doc, "../../../dtd/express.dtd");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            System.out.println("PROBLEM: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static SdaiIterator convertInterfacedItems(AInterfaced_declaration i_items, SdaiIterator iter_auxil, Element parent, Document doc) throws SdaiException {
        if (i_items.getMemberCount() > 0) {
            if (iter_auxil == null) {
                iter_auxil = i_items.createIterator();
            } else {
                i_items.attachIterator(iter_auxil);
            }
            while (iter_auxil.next()) {
                EInterfaced_declaration item = (EInterfaced_declaration)i_items.getCurrentMemberEntity(iter_auxil);
                if (item instanceof EImplicit_declaration) continue;
                Element item_elem = doc.createElement("interfaced.item");
                parent.appendChild(item_elem);
                Attr atr = doc.createAttribute("name");
                EEntity item_def = item.getDefinition(null);
                if (item_def instanceof EDefined_type) {
                    atr.setValue(((EDefined_type)item_def).getName(null));
                } else if (item_def instanceof EEntity_definition) {
                    atr.setValue(ExpressXmlConverter.getCorrectedName((EData_type)((EEntity_definition)item_def)));
                } else if (item_def instanceof EAlgorithm_definition) {
                    atr.setValue(((EAlgorithm_definition)item_def).getName(null));
                } else if (item_def instanceof EConstant_definition) {
                    atr.setValue(((EConstant_definition)item_def).getName(null));
                }
                item_elem.setAttributeNode(atr);
                if (!item.testAlias_name(null)) continue;
                atr = doc.createAttribute("alias");
                atr.setValue(item.getAlias_name(null));
                item_elem.setAttributeNode(atr);
            }
        }
        return iter_auxil;
    }

    private static SdaiIterator takeExpression(AEntity xpr_code_aggr, EEntity owner, SdaiIterator iter_auxil, Element parent, String attr_name, Document doc) throws SdaiException {
        if (iter_auxil == null) {
            iter_auxil = xpr_code_aggr.createIterator();
        } else {
            xpr_code_aggr.attachIterator(iter_auxil);
        }
        String value = null;
        while (iter_auxil.next()) {
            EExpress_code xpr_code = (EExpress_code)xpr_code_aggr.getCurrentMemberEntity(iter_auxil);
            if (xpr_code.getTarget(null) != owner) continue;
            A_string expression_aggr = xpr_code.getValues(null);
            value = expression_aggr.getByIndex(1);
            break;
        }
        if (value != null) {
            Attr atr = doc.createAttribute(attr_name);
            atr.setValue(value);
            parent.setAttributeNode(atr);
        }
        return iter_auxil;
    }

    private static String convertSuperExpression(EEntity_definition definition, SdaiIterator iter_auxil, ASub_supertype_constraint subtypes) throws SdaiException {
        if (subtypes == null) {
            subtypes = new ASub_supertype_constraint();
        }
        String super_expres = "";
        CSub_supertype_constraint.usedinGeneric_supertype(null, (EEntity_or_view_definition)definition, null, (AEntity)subtypes);
        if (subtypes.getMemberCount() > 0) {
            if (iter_auxil == null) {
                iter_auxil = subtypes.createIterator();
            } else {
                subtypes.attachIterator(iter_auxil);
            }
            while (iter_auxil.next()) {
                ESub_supertype_constraint subtp = subtypes.getCurrentMember(iter_auxil);
                if (!subtp.testConstraint(null) || subtp.testName(null)) continue;
                super_expres = super_expres + ExpressXmlConverter.convertSubtypeConstraint(subtp.getConstraint(null));
            }
        }
        subtypes.clear();
        if (super_expres.length() > 1 && super_expres.substring(0, 1).equals("(")) {
            return super_expres.substring(1, super_expres.length() - 1);
        }
        return super_expres;
    }

    private static String convertSubtypeConstraint(ESubtype_expression expression) throws SdaiException {
        String s_expres = "";
        if (expression.getGeneric_operands(null).getMemberCount() > 1) {
            if (expression instanceof EOneof_subtype_expression) {
                s_expres = s_expres + "ONEOF (";
                s_expres = s_expres + ExpressXmlConverter.convertOperands(expression, ", ");
                s_expres = s_expres + ")";
            } else if (expression instanceof EAndor_subtype_expression) {
                s_expres = s_expres + "(";
                s_expres = s_expres + ExpressXmlConverter.convertOperands(expression, " ANDOR ");
                s_expres = s_expres + ")";
            } else if (expression instanceof EAnd_subtype_expression) {
                s_expres = s_expres + "(";
                s_expres = s_expres + ExpressXmlConverter.convertOperands(expression, " AND ");
                s_expres = s_expres + ")";
            }
        } else {
            s_expres = s_expres + ExpressXmlConverter.convertOperands(expression, "");
        }
        return s_expres;
    }

    private static String convertOperands(ESubtype_expression expression, String separator) throws SdaiException {
        String oper_expres = "";
        AEntity_or_view_or_subtype_expression operands = expression.getGeneric_operands(null);
        SdaiIterator it_oper = operands.createIterator();
        boolean first = true;
        while (it_oper.next()) {
            if (first) {
                first = false;
            } else {
                oper_expres = oper_expres + separator;
            }
            EEntity oper = operands.getCurrentMemberEntity(it_oper);
            if (oper instanceof EEntity_definition) {
                oper_expres = oper_expres + ExpressXmlConverter.getCorrectedName((EData_type)((EEntity_definition)oper));
                continue;
            }
            if (!(oper instanceof ESubtype_expression)) continue;
            oper_expres = oper_expres + ExpressXmlConverter.convertSubtypeConstraint((ESubtype_expression)oper);
        }
        return oper_expres;
    }

    private static SdaiIterator convertWhereRules(AWhere_rule w_rules, EWhere_rule[] wh_rules, AEntity xpr_code_aggr, SdaiIterator iter_auxil, SdaiIterator iter_auxil2, Element parent, Document doc) throws SdaiException {
        int ln = w_rules.getMemberCount();
        if (ln > 0) {
            if (wh_rules == null || ln > wh_rules.length) {
                wh_rules = new EWhere_rule[ln];
            }
            if (iter_auxil == null) {
                iter_auxil = w_rules.createIterator();
            } else {
                w_rules.attachIterator(iter_auxil);
            }
            int wr_count = 0;
            while (iter_auxil.next()) {
                wh_rules[wr_count++] = (EWhere_rule)w_rules.getCurrentMemberEntity(iter_auxil);
            }
            Arrays.sort(wh_rules, 0, wr_count, new SorterForWheres());
            for (int i = 0; i < wr_count; ++i) {
                EWhere_rule w_rule = wh_rules[i];
                Element w_rule_elem = doc.createElement("where");
                parent.appendChild(w_rule_elem);
                if (w_rule.testLabel(null)) {
                    Attr atr = doc.createAttribute("label");
                    atr.setValue(ExpressXmlConverter.getCorrectedName(w_rule));
                    w_rule_elem.setAttributeNode(atr);
                }
                ExpressXmlConverter.takeExpression(xpr_code_aggr, (EEntity)w_rule, iter_auxil2, w_rule_elem, "expression", doc);
            }
        }
        return iter_auxil;
    }

    private static SdaiIterator convertUniquenessRules(AUniqueness_rule u_rules, EUniqueness_rule[] un_rules, SdaiIterator iter_auxil, Element parent, Document doc) throws SdaiException {
        SdaiIterator iter_attrs = null;
        int ln = u_rules.getMemberCount();
        if (ln > 0) {
            EUniqueness_rule u_rule;
            int i;
            if (un_rules == null || ln > un_rules.length) {
                un_rules = new EUniqueness_rule[ln];
            }
            if (iter_auxil == null) {
                iter_auxil = u_rules.createIterator();
            } else {
                u_rules.attachIterator(iter_auxil);
            }
            int ur_count = 0;
            while (iter_auxil.next()) {
                un_rules[ur_count++] = (EUniqueness_rule)u_rules.getCurrentMemberEntity(iter_auxil);
            }
            for (i = 0; i < ur_count / 2; ++i) {
                u_rule = un_rules[i];
                un_rules[i] = un_rules[ur_count - i - 1];
                un_rules[ur_count - i - 1] = u_rule;
            }
            for (i = 0; i < ur_count; ++i) {
                Attr atr;
                u_rule = un_rules[i];
                Element u_rule_elem = doc.createElement("unique");
                parent.appendChild(u_rule_elem);
                if (u_rule.testLabel(null)) {
                    atr = doc.createAttribute("label");
                    atr.setValue(ExpressXmlConverter.getCorrectedName(u_rule));
                    u_rule_elem.setAttributeNode(atr);
                }
                EEntity_definition def = u_rule.getParent_entity(null);
                String def_name = def.getName(null);
                AAttribute attrs = u_rule.getAttributes(null);
                int count = attrs.getMemberCount();
                if (iter_attrs == null) {
                    iter_attrs = attrs.createIterator();
                } else {
                    attrs.attachIterator(iter_attrs);
                }
                while (iter_attrs.next()) {
                    EAttribute attrib = (EAttribute)attrs.getCurrentMemberEntity(iter_attrs);
                    Element attrib_elem = doc.createElement("unique.attribute");
                    u_rule_elem.appendChild(attrib_elem);
                    EEntity_definition parent_def = attrib.getParent_entity(null);
                    if (parent_def != def) {
                        atr = doc.createAttribute("entity-ref");
                        atr.setValue(ExpressXmlConverter.getCorrectedName((EData_type)parent_def));
                        attrib_elem.setAttributeNode(atr);
                    }
                    atr = doc.createAttribute("attribute");
                    atr.setValue(attrib.getName(null));
                    attrib_elem.setAttributeNode(atr);
                }
            }
        }
        return iter_auxil;
    }

    private static SdaiIterator convertParameters(AParameter parameters, SdaiIterator iter_auxil, Element parent, Document doc) throws SdaiException {
        if (parameters.getMemberCount() > 0) {
            if (iter_auxil == null) {
                iter_auxil = parameters.createIterator();
            } else {
                parameters.attachIterator(iter_auxil);
            }
            while (iter_auxil.next()) {
                EParameter param = (EParameter)parameters.getCurrentMemberEntity(iter_auxil);
                Element param_elem = doc.createElement("parameter");
                parent.appendChild(param_elem);
                String name = param.getName(null);
                if (param.testVar_type(null) && param.getVar_type(null)) {
                    name = VAR_PARAMETER + name;
                }
                Attr atr = doc.createAttribute("name");
                atr.setValue(name);
                param_elem.setAttributeNode(atr);
                A_string labels = null;
                if (param.testType_labels(null)) {
                    labels = param.getType_labels(null);
                }
                ExpressXmlConverter.convertUnderType(param.getParameter_type(null), param_elem, doc, labels, 0);
            }
        }
        return iter_auxil;
    }

    private static SdaiIterator convertAlgorithm(AEntity xpr_code_aggr, EEntity def, SdaiIterator iter_auxil, Element parent, Document doc) throws SdaiException {
        if (iter_auxil == null) {
            iter_auxil = xpr_code_aggr.createIterator();
        } else {
            xpr_code_aggr.attachIterator(iter_auxil);
        }
        String value = null;
        while (iter_auxil.next()) {
            EExpress_code xpr_code = (EExpress_code)xpr_code_aggr.getCurrentMemberEntity(iter_auxil);
            if (xpr_code.getTarget(null) != def) continue;
            A_string expression_aggr = xpr_code.getValues(null);
            value = expression_aggr.getByIndex(1);
            break;
        }
        if (value != null && !value.equals("") && !value.equals(" ")) {
            Element alg_elem = doc.createElement("algorithm");
            parent.appendChild(alg_elem);
            Text txt = doc.createTextNode(value);
            alg_elem.appendChild(txt);
        }
        return iter_auxil;
    }

    private static void convertRedeclaration(EAttribute attrib, String atr_name, Element parent, Document doc) throws SdaiException {
        Element redecl_elem = doc.createElement("redeclaration");
        parent.appendChild(redecl_elem);
        Attr atr = doc.createAttribute("entity-ref");
        atr.setValue(ExpressXmlConverter.getCorrectedName((EData_type)attrib.getParent_entity(null)));
        redecl_elem.setAttributeNode(atr);
        String o_name = attrib.getName(null);
        if (!o_name.equals(atr_name)) {
            atr = doc.createAttribute("old_name");
            atr.setValue(o_name);
            redecl_elem.setAttributeNode(atr);
        }
    }

    private static void convertDefType(EData_type type, Element parent, Document doc) throws SdaiException {
        if (type instanceof EAggregation_type) {
            ExpressXmlConverter.convertTypeAggr((EAggregation_type)type, parent, doc, true, null, 0);
        } else if (type instanceof ESimple_type) {
            ExpressXmlConverter.convertTypeSimple((ESimple_type)type, parent, doc);
        } else if (type instanceof EDefined_type || type instanceof EEntity_definition) {
            ExpressXmlConverter.convertTypeNamed(type, parent, doc);
        } else if (type instanceof ESelect_type) {
            ExpressXmlConverter.convertTypeSelect((ESelect_type)type, parent, doc);
        } else if (type instanceof EEnumeration_type) {
            ExpressXmlConverter.convertTypeEnumeration((EEnumeration_type)type, parent, doc);
        }
    }

    private static void convertTypeSelect(ESelect_type sel_type, Element parent, Document doc) throws SdaiException {
        ANamed_type sels;
        int ln;
        Element elem = doc.createElement("select");
        parent.appendChild(elem);
        if (sel_type instanceof EExtensible_select_type) {
            Attr ext = doc.createAttribute("extensible");
            ext.setValue("YES");
            elem.setAttributeNode(ext);
        }
        if (sel_type instanceof EEntity_select_type) {
            Attr generic = doc.createAttribute("genericentity");
            generic.setValue("YES");
            elem.setAttributeNode(generic);
        }
        if (sel_type instanceof EExtended_select_type) {
            Attr based = doc.createAttribute("basedon");
            EDefined_type bas = ((EExtended_select_type)sel_type).getIs_based_on(null);
            if (bas instanceof EDefined_type) {
                based.setValue(bas.getName(null));
            } else {
                String str = bas.getName(null);
                str = str.substring(8);
                based.setValue(str);
            }
            elem.setAttributeNode(based);
        }
        if ((ln = (sels = sel_type.getSelections(null)).getMemberCount()) > 0) {
            Attr items = doc.createAttribute("selectitems");
            String selections = "";
            for (int i = 1; i <= ln; ++i) {
                EData_type alternative = (EData_type)sels.getByIndexObject(i);
                if (i > 1) {
                    selections = selections + " ";
                }
                String alt_name = alternative.getName(null);
                selections = selections + alt_name;
            }
            items.setValue(selections);
            elem.setAttributeNode(items);
        }
    }

    private static void convertTypeEnumeration(EEnumeration_type enum_type, Element parent, Document doc) throws SdaiException {
        A_string elems;
        int ln;
        Element elem = doc.createElement("enumeration");
        parent.appendChild(elem);
        if (enum_type instanceof EExtensible_enumeration_type) {
            Attr ext = doc.createAttribute("extensible");
            ext.setValue("YES");
            elem.setAttributeNode(ext);
        }
        if (enum_type instanceof EExtended_enumeration_type) {
            Attr based = doc.createAttribute("basedon");
            EDefined_type bas = ((EExtended_enumeration_type)enum_type).getIs_based_on(null);
            based.setValue(bas.getName(null));
            elem.setAttributeNode(based);
        }
        if ((ln = (elems = enum_type.getElements(null)).getMemberCount()) > 0) {
            Attr items = doc.createAttribute("items");
            String elements = "";
            for (int i = 1; i <= ln; ++i) {
                String element = (String)elems.getByIndexObject(i);
                if (i > 1) {
                    elements = elements + " ";
                }
                elements = elements + element;
            }
            items.setValue(elements);
            elem.setAttributeNode(items);
        }
    }

    private static SdaiIterator convertEntitiesAggr(AEntity_definition entities, String attr_name, SdaiIterator iter_auxil, Element parent, Document doc) throws SdaiException {
        Attr atr = doc.createAttribute(attr_name);
        if (iter_auxil == null) {
            iter_auxil = entities.createIterator();
        } else {
            entities.attachIterator(iter_auxil);
        }
        String ents = "";
        int i = 0;
        while (iter_auxil.next()) {
            EEntity_definition ent_def = (EEntity_definition)entities.getCurrentMemberEntity(iter_auxil);
            String name_norm = ExpressXmlConverter.getCorrectedName((EData_type)ent_def);
            if (++i > 1) {
                ents = ents + " ";
            }
            ents = ents + name_norm;
        }
        atr.setValue(ents);
        parent.setAttributeNode(atr);
        return iter_auxil;
    }

    private static void convertExplicitAttribute(EExplicit_attribute ent_at, Element parent, Document doc) throws SdaiException {
        Element attr_elem = doc.createElement("explicit");
        parent.appendChild(attr_elem);
        Attr atr = doc.createAttribute("name");
        String a_name = ent_at.getName(null);
        atr.setValue(a_name);
        attr_elem.setAttributeNode(atr);
        if (ent_at.getOptional_flag(null)) {
            atr = doc.createAttribute("optional");
            atr.setValue("YES");
            attr_elem.setAttributeNode(atr);
        }
        ExpressXmlConverter.convertUnderType((EData_type)ent_at.getDomain(null), attr_elem, doc, null, 0);
        if (ent_at.testRedeclaring(null)) {
            ExpressXmlConverter.convertRedeclaration((EAttribute)ent_at.getRedeclaring(null), a_name, attr_elem, doc);
        }
    }

    private static SdaiIterator convertDerivedAttribute(EDerived_attribute ent_at, AEntity xpr_code_aggr, SdaiIterator iter_auxil2, Element parent, Document doc) throws SdaiException {
        SdaiIterator iter;
        Element attr_elem = doc.createElement("derived");
        parent.appendChild(attr_elem);
        Attr atr = doc.createAttribute("name");
        String a_name = ent_at.getName(null);
        atr.setValue(a_name);
        attr_elem.setAttributeNode(atr);
        if (xpr_code_aggr != null && (iter = ExpressXmlConverter.takeExpression(xpr_code_aggr, (EEntity)ent_at, iter_auxil2, attr_elem, "expression", doc)) != null) {
            iter_auxil2 = iter;
        }
        ExpressXmlConverter.convertUnderType((EData_type)ent_at.getDomain(null), attr_elem, doc, null, 0);
        if (ent_at.testRedeclaring(null)) {
            ExpressXmlConverter.convertRedeclaration((EAttribute)ent_at.getRedeclaring(null), a_name, attr_elem, doc);
        }
        return iter_auxil2;
    }

    private static void convertInverseAttribute(EInverse_attribute ent_at, Element parent, Document doc) throws SdaiException {
        Element attr_elem = doc.createElement("inverse");
        parent.appendChild(attr_elem);
        Attr atr = doc.createAttribute("name");
        String a_name = ent_at.getName(null);
        atr.setValue(a_name);
        attr_elem.setAttributeNode(atr);
        atr = doc.createAttribute("entity");
        EEntity_definition def = ent_at.getDomain(null);
        atr.setValue(ExpressXmlConverter.getCorrectedName((EData_type)def));
        attr_elem.setAttributeNode(atr);
        atr = doc.createAttribute("attribute");
        EExplicit_attribute inver_attr = ent_at.getInverted_attr(null);
        atr.setValue(inver_attr.getName(null));
        attr_elem.setAttributeNode(atr);
        if (ent_at.testMin_cardinality(null)) {
            Element inv_aggr_elem = doc.createElement("inverse.aggregate");
            attr_elem.appendChild(inv_aggr_elem);
            atr = doc.createAttribute("type");
            if (ent_at.getDuplicates(null)) {
                atr.setValue("BAG");
            } else {
                atr.setValue("SET");
            }
            inv_aggr_elem.setAttributeNode(atr);
            EBound bnd = ent_at.getMin_cardinality(null);
            atr = doc.createAttribute("lower");
            atr.setValue(Integer.toString(bnd.getBound_value(null)));
            inv_aggr_elem.setAttributeNode(atr);
            atr = doc.createAttribute("upper");
            if (ent_at.testMax_cardinality(null)) {
                bnd = ent_at.getMax_cardinality(null);
                atr.setValue(Integer.toString(bnd.getBound_value(null)));
            } else {
                atr.setValue("?");
            }
            inv_aggr_elem.setAttributeNode(atr);
        }
        if (ent_at.testRedeclaring(null)) {
            ExpressXmlConverter.convertRedeclaration((EAttribute)ent_at.getRedeclaring(null), a_name, attr_elem, doc);
        }
    }

    private static void convertUnderType(EData_type type, Element parent, Document doc, Object labels, int index) throws SdaiException {
        if (type instanceof EAggregation_type) {
            ExpressXmlConverter.convertTypeAggr((EAggregation_type)type, parent, doc, false, labels, index);
        } else if (type instanceof ESimple_type) {
            ExpressXmlConverter.convertTypeSimple((ESimple_type)type, parent, doc);
        } else if (type instanceof EDefined_type || type instanceof EEntity_definition) {
            ExpressXmlConverter.convertTypeNamed(type, parent, doc);
        } else if (type.getName(null).equals("_ENTITY")) {
            String lb;
            Element elem = doc.createElement("builtintype");
            parent.appendChild(elem);
            Attr type_atr = doc.createAttribute("type");
            type_atr.setValue("GENERICENTITY");
            elem.setAttributeNode(type_atr);
            if (labels != null && (lb = ExpressXmlConverter.getLabel(labels, index)) != null) {
                type_atr = doc.createAttribute("typelabel");
                type_atr.setValue(lb);
                elem.setAttributeNode(type_atr);
            }
        } else if (type.getName(null).equals("_GENERIC")) {
            String lb;
            Element elem = doc.createElement("builtintype");
            parent.appendChild(elem);
            Attr type_atr = doc.createAttribute("type");
            type_atr.setValue("GENERIC");
            elem.setAttributeNode(type_atr);
            if (labels != null && (lb = ExpressXmlConverter.getLabel(labels, index)) != null) {
                type_atr = doc.createAttribute("typelabel");
                type_atr.setValue(lb);
                elem.setAttributeNode(type_atr);
            }
        }
    }

    private static void convertTypeAggr(EAggregation_type aggr_type, Element parent, Document doc, boolean def_type, Object labels, int index) throws SdaiException {
        Attr un;
        Element elem = doc.createElement("aggregate");
        parent.appendChild(elem);
        Attr type_aggr = doc.createAttribute("type");
        int var_aggr = 0;
        if (aggr_type instanceof ESet_type) {
            type_aggr.setValue("SET");
            elem.setAttributeNode(type_aggr);
        } else if (aggr_type instanceof EList_type) {
            type_aggr.setValue("LIST");
            elem.setAttributeNode(type_aggr);
            var_aggr = 1;
        } else if (aggr_type instanceof EBag_type) {
            type_aggr.setValue("BAG");
            elem.setAttributeNode(type_aggr);
        } else if (aggr_type instanceof EArray_type) {
            type_aggr.setValue("ARRAY");
            elem.setAttributeNode(type_aggr);
            var_aggr = 2;
        } else {
            String lb;
            type_aggr.setValue("AGGREGATE");
            elem.setAttributeNode(type_aggr);
            if (labels != null && (lb = ExpressXmlConverter.getLabel(labels, index)) != null) {
                type_aggr = doc.createAttribute("typelabel");
                type_aggr.setValue(lb);
                elem.setAttributeNode(type_aggr);
            }
            var_aggr = 3;
        }
        if (var_aggr == 1 && ((EList_type)aggr_type).getUnique_flag(null)) {
            un = doc.createAttribute("unique");
            un.setValue("YES");
            elem.setAttributeNode(un);
        }
        if (var_aggr < 2) {
            EVariable_size_aggregation_type var_aggr_type = (EVariable_size_aggregation_type)aggr_type;
            EBound bnd = var_aggr_type.getLower_bound(null);
            Attr low = doc.createAttribute("lower");
            low.setValue(Integer.toString(bnd.getBound_value(null)));
            elem.setAttributeNode(low);
            Attr upp = doc.createAttribute("upper");
            if (var_aggr_type.testUpper_bound(null)) {
                bnd = var_aggr_type.getUpper_bound(null);
                upp.setValue(Integer.toString(bnd.getBound_value(null)));
            } else {
                upp.setValue("?");
            }
            elem.setAttributeNode(upp);
        } else if (var_aggr == 2) {
            Attr low;
            EBound bnd;
            EArray_type arr = (EArray_type)aggr_type;
            if (arr.getOptional_flag(null)) {
                Attr opt = doc.createAttribute("optional");
                opt.setValue("YES");
                elem.setAttributeNode(opt);
            }
            if (arr.getUnique_flag(null)) {
                un = doc.createAttribute("unique");
                un.setValue("YES");
                elem.setAttributeNode(un);
            }
            if (arr.testLower_index(null)) {
                bnd = arr.getLower_index(null);
                low = doc.createAttribute("lower");
                low.setValue(Integer.toString(bnd.getBound_value(null)));
                elem.setAttributeNode(low);
            }
            if (arr.testUpper_index(null)) {
                bnd = arr.getUpper_index(null);
                low = doc.createAttribute("upper");
                low.setValue(Integer.toString(bnd.getBound_value(null)));
                elem.setAttributeNode(low);
            }
        }
        if (def_type) {
            ExpressXmlConverter.convertDefType(aggr_type.getElement_type(null), parent, doc);
        } else {
            ExpressXmlConverter.convertUnderType(aggr_type.getElement_type(null), parent, doc, labels, index + 1);
        }
    }

    private static void convertTypeSimple(ESimple_type type, Element parent, Document doc) throws SdaiException {
        Element elem = doc.createElement("builtintype");
        parent.appendChild(elem);
        Attr type_atr = doc.createAttribute("type");
        if (type instanceof ENumber_type) {
            type_atr.setValue("NUMBER");
            elem.setAttributeNode(type_atr);
        } else if (type instanceof EInteger_type) {
            type_atr.setValue("INTEGER");
            elem.setAttributeNode(type_atr);
        } else if (type instanceof EReal_type) {
            type_atr.setValue("REAL");
            elem.setAttributeNode(type_atr);
            if (((EReal_type)type).testPrecision(null)) {
                EBound bnd = ((EReal_type)type).getPrecision(null);
                Attr prec = doc.createAttribute("precision");
                prec.setValue(Integer.toString(bnd.getBound_value(null)));
                elem.setAttributeNode(prec);
            }
        } else if (type instanceof EBoolean_type) {
            type_atr.setValue("BOOLEAN");
            elem.setAttributeNode(type_atr);
        } else if (type instanceof ELogical_type) {
            type_atr.setValue("LOGICAL");
            elem.setAttributeNode(type_atr);
        } else if (type instanceof EBinary_type) {
            type_atr.setValue("BINARY");
            elem.setAttributeNode(type_atr);
            if (((EBinary_type)type).testWidth(null)) {
                EBound bnd = ((EBinary_type)type).getWidth(null);
                Attr width = doc.createAttribute("width");
                width.setValue(Integer.toString(bnd.getBound_value(null)));
                elem.setAttributeNode(width);
            }
            if (((EBinary_type)type).getFixed_width(null)) {
                Attr fix = doc.createAttribute("fixed");
                fix.setValue("YES");
                elem.setAttributeNode(fix);
            }
        } else if (type instanceof EString_type) {
            type_atr.setValue("STRING");
            elem.setAttributeNode(type_atr);
            EString_type str_type = (EString_type)type;
            if (str_type.testWidth(null)) {
                EBound bnd = str_type.getWidth(null);
                Attr width = doc.createAttribute("width");
                width.setValue(Integer.toString(bnd.getBound_value(null)));
                elem.setAttributeNode(width);
            }
            if (str_type.testFixed_width(null) && str_type.getFixed_width(null)) {
                Attr fix = doc.createAttribute("fixed");
                fix.setValue("YES");
                elem.setAttributeNode(fix);
            }
        }
    }

    private static String getLabel(Object labels, int index) throws SdaiException {
        String lb;
        if (labels instanceof A_string) {
            String lb2;
            A_string lab_aggr = (A_string)labels;
            if (index < lab_aggr.getMemberCount() && (lb2 = lab_aggr.getByIndex(index + 1)).length() > 0) {
                return lb2;
            }
        } else if (labels instanceof String && (lb = (String)labels).length() > 0) {
            return lb;
        }
        return null;
    }

    private static void convertTypeNamed(EData_type type, Element parent, Document doc) throws SdaiException {
        Element elem = doc.createElement("typename");
        parent.appendChild(elem);
        Attr atr = doc.createAttribute("name");
        String tp_name = type.getName(null);
        atr.setValue(tp_name);
        elem.setAttributeNode(atr);
    }

    private static String getCorrectedName(EData_type def) throws SdaiException {
        String ent_name = def.getName(null);
        return ent_name;
    }

    private static String getCorrectedName(jsdai.SExtended_dictionary_schema.ESchema_definition sch) throws SdaiException {
        String sch_name = sch.getName(null);
        return sch_name;
    }

    private static String getCorrectedName(EGlobal_rule rule) throws SdaiException {
        String rule_name = rule.getName(null);
        return rule_name;
    }

    private static String getCorrectedName(EWhere_rule rule) throws SdaiException {
        String rule_name = rule.getLabel(null);
        return rule_name;
    }

    private static String getCorrectedName(EUniqueness_rule rule) throws SdaiException {
        String rule_name = rule.getLabel(null);
        return rule_name;
    }

    private static String getCorrectedName(EFunction_definition funct) throws SdaiException {
        String funct_name = funct.getName(null);
        return funct_name;
    }

    private static String getCorrectedName(EProcedure_definition proc) throws SdaiException {
        String proc_name = proc.getName(null);
        return proc_name;
    }

    static class MyErrorHandler
    implements ErrorHandler {
        MyErrorHandler() {
        }

        public void error(SAXParseException exception) throws SAXParseException {
            System.out.println("\r\n** ERROR:\r\n line " + exception.getLineNumber() + "\r\n url " + exception.getSystemId());
            throw exception;
        }

        public void fatalError(SAXParseException exception) throws SAXParseException {
            System.out.println("\r\n** FATAL ERROR:\r\n line " + exception.getLineNumber() + "\r\n url " + exception.getSystemId());
            throw exception;
        }

        public void warning(SAXParseException exception) throws SAXParseException {
            System.out.println("** Warning, line " + exception.getLineNumber() + ", uri " + exception.getSystemId());
            System.out.println("   " + exception.getMessage());
        }
    }

    static class SorterForWheres
    implements Comparator {
        SorterForWheres() {
        }

        public int compare(Object o1, Object o2) {
            try {
                if (((EWhere_rule)o1).getOrder(null) < ((EWhere_rule)o2).getOrder(null)) {
                    return -1;
                }
                return 1;
            }
            catch (SdaiException e) {
                e.printStackTrace(System.out);
                return 0;
            }
        }
    }

    static class SorterForFunctions
    implements Comparator {
        SorterForFunctions() {
        }

        public int compare(Object o1, Object o2) {
            try {
                return ((EFunction_definition)o1).getName(null).compareTo(((EFunction_definition)o2).getName(null));
            }
            catch (SdaiException e) {
                e.printStackTrace(System.out);
                return 0;
            }
        }
    }

    static class SorterForRules
    implements Comparator {
        SorterForRules() {
        }

        public int compare(Object o1, Object o2) {
            try {
                return ((EGlobal_rule)o1).getName(null).compareTo(((EGlobal_rule)o2).getName(null));
            }
            catch (SdaiException e) {
                e.printStackTrace(System.out);
                return 0;
            }
        }
    }

    static class SorterForEntities
    implements Comparator {
        SorterForEntities() {
        }

        public int compare(Object o1, Object o2) {
            try {
                return ExpressXmlConverter.getCorrectedName((EData_type)((EEntity_definition)o1)).compareTo(ExpressXmlConverter.getCorrectedName((EData_type)((EEntity_definition)o2)));
            }
            catch (SdaiException e) {
                e.printStackTrace(System.out);
                return 0;
            }
        }
    }

    static class SorterForTypes
    implements Comparator {
        SorterForTypes() {
        }

        public int compare(Object o1, Object o2) {
            try {
                return ((EDefined_type)o1).getName(null).compareTo(((EDefined_type)o2).getName(null));
            }
            catch (SdaiException e) {
                e.printStackTrace(System.out);
                return 0;
            }
        }
    }
}

