/*
 * Decompiled with CFR 0.152.
 */
package jsdai.tools;

import com.lksoft.util.ArgumentsParser;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jsdai.lang.ASchemaInstance;
import jsdai.lang.SchemaInstance;
import jsdai.lang.SdaiException;
import jsdai.lang.SdaiIterator;
import jsdai.lang.SdaiRepository;
import jsdai.lang.SdaiSession;
import jsdai.tools.ExpressXmlConverter;
import jsdai.tools.Utils;

public final class ExpressXmlGenerator {
    private static final String REPOSITORY_NAME = "ExpressCompilerRepo";

    private ExpressXmlGenerator() {
    }

    private static File[] parseArgs(String[] args) {
        ArgumentsParser.Value stepmodArg = new ArgumentsParser.Value("-stepmod", true);
        stepmodArg.setValueName("stepmodDir");
        stepmodArg.setDescription("Path to stepmod. Example: c:/workspace/stepmod");
        ArgumentsParser.Value schemasArg = new ArgumentsParser.Value("-schemas", true);
        schemasArg.setValueName("schemasFile");
        schemasArg.setDescription("File that contains list of schemas that need their XML to be regenerated.");
        List<Object> argList = Arrays.asList(stepmodArg, schemasArg);
        if (!ArgumentsParser.parse((String[])args, argList)) {
            System.out.println(ArgumentsParser.getUsage((String)ExpressXmlGenerator.class.getName(), argList));
            return null;
        }
        File schemasFile = new File(schemasArg.getValue());
        if (!schemasFile.exists() || !schemasFile.isFile()) {
            System.out.println("Specified schemas file does not exists, or is a directory: " + schemasFile);
            return null;
        }
        File stepmodDir = new File(stepmodArg.getValue());
        if (!stepmodDir.exists() || !stepmodDir.isDirectory()) {
            System.out.println("Specified stepmod dir does not exists. Creating: " + stepmodDir);
            if (!stepmodDir.mkdirs()) {
                System.out.println("Unable to create dir: " + stepmodDir);
                return null;
            }
        }
        return new File[]{stepmodDir, schemasFile};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws SdaiException {
        File[] parsedArgs = ExpressXmlGenerator.parseArgs(args);
        if (parsedArgs == null) {
            return;
        }
        File stepmodDir = parsedArgs[0];
        File schemasFile = parsedArgs[1];
        boolean success = false;
        try {
            System.out.println("Opening repo: ExpressCompilerRepo");
            SdaiRepository repo = Utils.getRepo(REPOSITORY_NAME);
            if (repo != null) {
                System.out.println("Reading schemas file: " + schemasFile);
                Set schemas = Utils.toLowerCase(new HashSet(Utils.readListFile(schemasFile)));
                System.out.println("Converting schemas...");
                try {
                    success = ExpressXmlGenerator.convertSchemas(stepmodDir, schemas, repo);
                }
                catch (SdaiException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (SdaiException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            SdaiSession session = SdaiSession.getSession();
            if (session != null) {
                session.closeSession();
            }
        }
        if (success) {
            System.out.println("Success.");
        } else {
            System.out.println("Failed.");
        }
    }

    private static boolean convertSchemas(File stepmodDir, Set schemaNames, SdaiRepository repo) throws SdaiException {
        File resourcesDir;
        File modulesDir = new File(stepmodDir, "data/modules");
        if (!modulesDir.exists() || !modulesDir.isDirectory()) {
            System.out.println("Modules dir does not exist. Creating: " + modulesDir);
            if (!modulesDir.mkdirs()) {
                System.out.println("Unable to create dir: " + modulesDir);
                return false;
            }
        }
        if (!(resourcesDir = new File(stepmodDir, "data/resources")).exists() || !resourcesDir.isDirectory()) {
            System.out.println("Resources dir does not exist. Creating: " + resourcesDir);
            if (!resourcesDir.mkdirs()) {
                System.out.println("Unable to create dir: " + resourcesDir);
                return false;
            }
        }
        ASchemaInstance schemas = repo.getSchemas();
        SdaiIterator it1 = schemas.createIterator();
        while (it1.next()) {
            String xmlFile;
            File moduleDir;
            SchemaInstance schema = schemas.getCurrentMember(it1);
            String schemaName = schema.getName();
            if (!schemaNames.contains(schemaName.toLowerCase())) continue;
            if (schemaName.matches("\\w+(?>_arm)|(?>_ARM)")) {
                moduleDir = new File(modulesDir, schemaName.substring(0, schemaName.length() - 4));
                xmlFile = "arm.xml";
            } else if (schemaName.matches("\\w+(?>_mim)|(?>_MIM)")) {
                moduleDir = new File(modulesDir, schemaName.substring(0, schemaName.length() - 4));
                xmlFile = "mim.xml";
            } else {
                moduleDir = new File(resourcesDir, schemaName);
                xmlFile = schemaName + ".xml";
            }
            if (!(moduleDir.exists() && moduleDir.isDirectory() || moduleDir.mkdirs())) {
                System.out.println("Module does not exist: " + moduleDir.getPath());
                continue;
            }
            File path = new File(moduleDir, xmlFile);
            ExpressXmlConverter.convertSchemaInstance(schema, path.getPath());
            System.out.println("Created: " + path.getPath());
            schemaNames.remove(schemaName);
        }
        for (String schemaName : schemaNames) {
            System.out.println("Schema " + schemaName + " was not found in the repository.");
        }
        return true;
    }
}

