/*
 * Decompiled with CFR 0.152.
 */
package jsdai.tools;

import com.lksoft.util.ArgumentsParser;
import java.io.File;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilderFactory;
import jsdai.tools.ModulesLister;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class IsoDbCreator {
    private IsoDbCreator() {
    }

    private static Object[] parseArgs(String[] args) {
        ArgumentsParser.Value stepmodArg = new ArgumentsParser.Value("-stepmod", true);
        stepmodArg.setValueName("stepmodDir");
        stepmodArg.setDescription("Path to stepmod. Example: c:/workspace/stepmod");
        ArgumentsParser.Value sufixArg = new ArgumentsParser.Value("-sufix", false);
        sufixArg.setValueName("sufix1[;sufix2[;...]]");
        sufixArg.setDescription("List of semicolumn seperated sufixes to be appended to module names.");
        List<Object> argList = Arrays.asList(stepmodArg, sufixArg);
        if (!ArgumentsParser.parse((String[])args, argList)) {
            System.out.println(ArgumentsParser.getUsage((String)ModulesLister.class.getName(), argList));
            return null;
        }
        File stepmodDir = new File(stepmodArg.getValue());
        if (!stepmodDir.exists() || !stepmodDir.isDirectory()) {
            System.out.println("Specified stepmod dir does not exists: " + stepmodDir);
            return null;
        }
        LinkedList<String> sufixes = new LinkedList<String>();
        if (sufixArg.getIsSet()) {
            String s = sufixArg.getValue();
            StringTokenizer st = new StringTokenizer(s, ";");
            while (st.hasMoreTokens()) {
                sufixes.add(st.nextToken());
            }
        }
        if (sufixes.size() == 0) {
            sufixes.add("");
        }
        return new Object[]{stepmodDir, sufixes};
    }

    public static void main(String[] args) {
        Object[] parsedArgs = IsoDbCreator.parseArgs(args);
        if (parsedArgs == null) {
            return;
        }
        File stepmod = (File)parsedArgs[0];
        List sufixes = (List)parsedArgs[1];
        File[] modules = new File(stepmod, "data/modules").listFiles();
        for (int i = 0; i < modules.length; ++i) {
            String[] attrs;
            File file = new File(modules[i], "module.xml");
            if (!file.exists() || (attrs = IsoDbCreator.getModuleAttrs(file)) == null) continue;
            for (String sufix : sufixes) {
                System.out.println(attrs[0] + sufix + "," + IsoDbCreator.getIsoNr(attrs[1], attrs[2]));
            }
        }
    }

    public static String getIsoNr(String status, String part) {
        return "ISO/" + status + " 10303-" + part;
    }

    public static String[] getModuleAttrs(File file) {
        Document module;
        try {
            module = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
        }
        catch (Exception e) {
            System.err.println("Unable to parse: " + file);
            return null;
        }
        Element root = module.getDocumentElement();
        String name = root.getAttribute("name");
        if (name == null) {
            System.err.println("Unable to get name for: " + file);
            return null;
        }
        String part = root.getAttribute("part");
        if (part == null) {
            System.err.println("Unable to get part for: " + file);
            return null;
        }
        String status = root.getAttribute("status");
        if (status == null) {
            System.err.println("Unable to get status for: " + file);
            return null;
        }
        return new String[]{name, status, part};
    }
}

