/*
 * Decompiled with CFR 0.152.
 */
package jsdai.tools;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;
import java.util.SortedSet;
import jsdai.tools.ModuleFinder;
import jsdai.tools.Utils;

public final class LongForm {
    private LongForm() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Properties props;
        if (args.length != 2) {
            System.out.println("Invalid usage. Should be:");
            System.out.println("java modules.LongForm outputFileName propsFileName");
            System.out.println();
            System.out.println(" outputFileName - the name of file that shall store the result.");
            System.out.println(" propsFileName - the name of file with properties.");
            System.out.println();
            System.out.println("Example:");
            System.out.println("  java modules.LongForm arm.exp longform.prop");
            return;
        }
        String outFile = args[0];
        try {
            props = Utils.loadProperties(args[1]);
        }
        catch (IOException e) {
            System.err.println("Fatal error has occurred: " + e);
            return;
        }
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new FileWriter(outFile));
            SortedSet modules = ModuleFinder.getExpress(props);
            for (String module : modules) {
                String s;
                BufferedReader reader = new BufferedReader(new FileReader(module));
                while ((s = reader.readLine()) != null) {
                    writer.println(s);
                }
                reader.close();
            }
            System.out.println("Output in file: " + outFile);
        }
        catch (IOException e) {
            System.err.println("Fatal error has occurred: " + e);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }
}

