/*
 * Decompiled with CFR 0.152.
 */
package jsdai.tools;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jsdai.tools.Utils;

public final class ModuleFinder {
    public static final Pattern PAT_BLOCK_COMMENTS = Pattern.compile("(?>(?>[*][)])|\\A)(.*?)(?>(?>[(][*])|\\z)", 32);
    public static final Pattern PAT_USEFROM = Pattern.compile("^(.*?)USE\\s+FROM\\s+(\\w+)", 8);
    public static final Pattern PAT_REFERENCEFROM = Pattern.compile("^(.*?)REFERENCE\\s+FROM\\s+(\\w+)", 8);
    public static final String PROP_STEPMOD_DIR = "stepmod";
    public static final String PROP_FIXED_DIR = "fixed";
    public static final String TYPE = "type";
    public static final String PROP_ROOT_MODULES = "roots";

    private ModuleFinder() {
    }

    private static void getUsefroms(Matcher m, Set usefroms) {
        while (m.find()) {
            String prefix = m.group(1);
            if (prefix.indexOf("--") >= 0) continue;
            String schema = m.group(2).toLowerCase();
            String module = schema.endsWith("_schema") || schema.startsWith("aic_") ? schema : schema.substring(0, schema.lastIndexOf(95));
            usefroms.add(module);
        }
    }

    public static Set[] getUsefromsEx(File file) {
        String express;
        try {
            express = Utils.read(file);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        HashSet usefroms = new HashSet();
        HashSet reffroms = new HashSet();
        Matcher blocks = PAT_BLOCK_COMMENTS.matcher(express);
        while (blocks.find()) {
            String uncommnented = blocks.group(1);
            if (uncommnented == null) continue;
            Matcher m = PAT_USEFROM.matcher(uncommnented);
            ModuleFinder.getUsefroms(m, usefroms);
            m = PAT_REFERENCEFROM.matcher(uncommnented);
            ModuleFinder.getUsefroms(m, reffroms);
        }
        return new Set[]{usefroms, reffroms};
    }

    public static Set getUsefroms(File file) {
        Set[] usefroms = ModuleFinder.getUsefromsEx(file);
        if (usefroms == null) {
            return null;
        }
        usefroms[0].addAll(usefroms[1]);
        return usefroms[0];
    }

    public static SortedSet getExpress(Properties props) {
        HashSet uncheckedModules = new HashSet();
        HashSet<String> checkedModules = new HashSet<String>();
        TreeSet<String> expressFiles = new TreeSet<String>();
        HashSet<String> rootModules = new HashSet<String>();
        String s = props.getProperty(PROP_ROOT_MODULES);
        StringTokenizer st = new StringTokenizer(s, ",");
        while (st.hasMoreTokens()) {
            s = st.nextToken();
            rootModules.add(s);
        }
        uncheckedModules.addAll(rootModules);
        String stepmod = props.getProperty(PROP_STEPMOD_DIR);
        if (!new File(stepmod).exists()) {
            System.err.println("Stepmod dir does not exist: " + stepmod);
            return expressFiles;
        }
        String fixedmodules = props.getProperty(PROP_FIXED_DIR) + "/";
        if (!new File(stepmod).exists()) {
            System.err.println("Stepmod dir does not exist: " + stepmod);
            return expressFiles;
        }
        String modulesDir = stepmod + "/data/modules/";
        if (!new File(modulesDir).exists()) {
            System.err.println("Modules dir does not exist: " + modulesDir);
            return expressFiles;
        }
        String irDir = stepmod + "/data/resources/";
        if (!new File(irDir).exists()) {
            System.err.println("Resources dir does not exist: " + irDir);
            return expressFiles;
        }
        String type = props.getProperty(TYPE);
        if (!(type.equals("arm") || type.equals("mim") || type.equals("xim"))) {
            System.err.println("Unresolved module type: " + type);
            return expressFiles;
        }
        while (uncheckedModules.size() > 0) {
            boolean isRes;
            String fileName;
            String module = (String)uncheckedModules.iterator().next();
            uncheckedModules.remove(module);
            if (module.endsWith("_schema") || module.startsWith("aic_")) {
                fileName = module + "/" + module + ".exp";
                isRes = true;
            } else {
                fileName = module + "/" + type + ".exp";
                isRes = false;
            }
            File file = new File(fixedmodules + fileName);
            if (!file.exists()) {
                file = isRes ? new File(irDir + fileName) : new File(modulesDir + fileName);
            } else {
                System.out.println("Taken from fixed dir: " + fileName);
            }
            if (!file.exists()) {
                System.err.println("Unable to find required file: " + file);
                continue;
            }
            Set usefroms = ModuleFinder.getUsefroms(file);
            if (usefroms == null) continue;
            checkedModules.add(module);
            expressFiles.add(file.getAbsolutePath());
            usefroms.removeAll(checkedModules);
            uncheckedModules.addAll(usefroms);
        }
        return expressFiles;
    }

    public static void main(String[] args) {
        Properties props;
        if (args.length != 1) {
            System.err.println("Only the properties file should be specified.");
            return;
        }
        try {
            props = Utils.loadProperties(args[0]);
        }
        catch (IOException e) {
            System.err.println("Fatal error has occurred: " + e);
            return;
        }
        SortedSet modules = ModuleFinder.getExpress(props);
        for (String module : modules) {
            System.out.println(module);
        }
    }
}

