/*
 * Decompiled with CFR 0.152.
 */
package jsdai.tools;

import com.lksoft.util.ArgumentsParser;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import jsdai.tools.ExpressXmlGenerator;
import jsdai.tools.IsoDbCreator;
import jsdai.tools.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public final class ModuleScopeRegenerator {
    private static final String SCOPE_PREFIX = "items within the scope of application module ";

    private ModuleScopeRegenerator() {
    }

    private static File[] parseArgs(String[] args) {
        ArgumentsParser.Value stepmodArg = new ArgumentsParser.Value("-stepmod", true);
        stepmodArg.setValueName("stepmodDir");
        stepmodArg.setDescription("Path to stepmod. Example: c:/workspace/stepmod");
        ArgumentsParser.Value modulesArg = new ArgumentsParser.Value("-modules", true);
        modulesArg.setValueName("modulesFile");
        modulesArg.setDescription("File that contains list of modules that need their scopes to be regenerated.");
        List<Object> argList = Arrays.asList(stepmodArg, modulesArg);
        if (!ArgumentsParser.parse((String[])args, argList)) {
            System.out.println(ArgumentsParser.getUsage((String)ExpressXmlGenerator.class.getName(), argList));
            return null;
        }
        File stepmodDir = new File(stepmodArg.getValue());
        if (!stepmodDir.exists() || !stepmodDir.isDirectory()) {
            System.out.println("Specified stepmod dir does not exists: " + stepmodDir);
            return null;
        }
        File schemasFile = new File(modulesArg.getValue());
        if (!schemasFile.exists() || !schemasFile.isFile()) {
            System.out.println("Specified modules file does not exists, or is a directory: " + schemasFile);
            return null;
        }
        return new File[]{stepmodDir, schemasFile};
    }

    public static void main(String[] args) throws IOException {
        File[] parsedArgs = ModuleScopeRegenerator.parseArgs(args);
        if (parsedArgs == null) {
            return;
        }
        File stepmodDir = parsedArgs[0];
        File modulesFile = parsedArgs[1];
        System.out.println("Reading modules file: " + modulesFile);
        HashSet modules = new HashSet(Utils.readListFile(modulesFile));
        System.out.println("Regenerating scopes...");
        ModuleScopeRegenerator.regenerateScope(stepmodDir, modules);
        System.out.println("Done.");
    }

    private static void regenerateScope(File stepmodDir, Set modules) {
        File modulesDir = new File(stepmodDir, "data/modules");
        for (String module : modules) {
            File moduleDir = new File(modulesDir, module);
            if (moduleDir.exists() && moduleDir.isDirectory()) {
                ModuleScopeRegenerator.regenerateScope(moduleDir);
                continue;
            }
            System.err.println("Module directory does not exist: " + moduleDir);
        }
    }

    private static String getIsoNr(File modulesDir, String armSchema) {
        String module = armSchema.substring(0, armSchema.indexOf("_arm")).toLowerCase();
        File moduleDir = new File(modulesDir, module);
        if (!moduleDir.exists()) {
            return null;
        }
        String[] attrs = IsoDbCreator.getModuleAttrs(new File(moduleDir, "module.xml"));
        if (attrs == null) {
            return null;
        }
        return IsoDbCreator.getIsoNr(attrs[1], attrs[2]);
    }

    private static void regenerateScope(File moduleDir) {
        ArrayList useFroms = new ArrayList(ModuleScopeRegenerator.gatherUseFroms(moduleDir, "arm.xml"));
        Collections.sort(useFroms);
        File file = new File(moduleDir, "module.xml");
        if (!file.exists()) {
            System.err.println("Module file does not exist: " + file);
            return;
        }
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            docFactory.setValidating(false);
            docFactory.setCoalescing(true);
            DocumentBuilder builder = docFactory.newDocumentBuilder();
            Document loadedDoc = builder.parse(file);
            NodeList nodeList = loadedDoc.getElementsByTagName("inscope");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                ModuleScopeRegenerator.deleteScope(node);
                Iterator j = useFroms.iterator();
                while (j.hasNext()) {
                    String schemaNodeValue = (String)j.next();
                    String isoNumber = ModuleScopeRegenerator.getIsoNr(moduleDir.getParentFile(), schemaNodeValue);
                    if (isoNumber == null) {
                        isoNumber = "ISO/CD-TS 10303-xxxx";
                    }
                    Element liNode = loadedDoc.createElement("li");
                    Element modRefNode = loadedDoc.createElement("module_ref");
                    int li = schemaNodeValue.lastIndexOf("_arm");
                    String linkendName = schemaNodeValue.substring(0, li);
                    linkendName = linkendName.toLowerCase();
                    String formedString = linkendName + ":1_scope";
                    modRefNode.setAttribute("linkend", formedString);
                    int li2 = schemaNodeValue.lastIndexOf("_arm");
                    String moduleName = schemaNodeValue.substring(0, li2);
                    moduleName = moduleName.replace('_', ' ');
                    Text linkendTextNode = loadedDoc.createTextNode(moduleName);
                    modRefNode.appendChild(linkendTextNode);
                    Text textNode1 = loadedDoc.createTextNode(SCOPE_PREFIX);
                    String formedString2 = ", " + isoNumber;
                    formedString2 = !j.hasNext() ? formedString2 + "." : formedString2 + ";";
                    Text textNode2 = loadedDoc.createTextNode(formedString2);
                    liNode.appendChild(textNode1);
                    liNode.appendChild(modRefNode);
                    liNode.appendChild(textNode2);
                    node.appendChild(liNode);
                }
            }
            DocumentType docType = loadedDoc.getDoctype();
            if (docType != null) {
                Utils.saveToFile(file.getCanonicalPath(), loadedDoc, docType.getSystemId());
                System.out.println("Regenerated: " + file);
            } else {
                System.out.println("Failed to regenerate: " + file);
            }
        }
        catch (TransformerConfigurationException e) {
            System.out.println("PROBLEM: " + e.getMessage());
            e.printStackTrace();
        }
        catch (TransformerException e) {
            System.out.println("PROBLEM: " + e.getMessage());
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            System.out.println("PROBLEM: " + e.getMessage());
            e.printStackTrace();
        }
        catch (SAXException sxe) {
            Exception x = sxe;
            if (sxe.getException() != null) {
                x = sxe.getException();
            }
            x.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private static void deleteScope(Node node) {
        Node child2;
        LinkedList<Node> remove = new LinkedList<Node>();
        NodeList childNodes = node.getChildNodes();
        block0: for (int i = 0; i < childNodes.getLength(); ++i) {
            Element elem;
            child2 = childNodes.item(i);
            if (!(child2 instanceof Element) || !(elem = (Element)child2).getTagName().equalsIgnoreCase("li")) continue;
            NodeList imgNodes = elem.getChildNodes();
            for (int j = 0; j < imgNodes.getLength(); ++j) {
                Node imgNode = imgNodes.item(j);
                String nodeValue = imgNode.getNodeValue();
                if (nodeValue == null || !nodeValue.startsWith(SCOPE_PREFIX)) continue;
                remove.add(child2);
                continue block0;
            }
        }
        for (Node child2 : remove) {
            node.removeChild(child2);
        }
        node.normalize();
        childNodes = node.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            child2 = childNodes.item(i);
            if (!(child2 instanceof Text)) continue;
            node.removeChild(child2);
        }
    }

    private static Collection gatherUseFroms(File modulesDir, String xmlFile) {
        File file = new File(modulesDir, xmlFile);
        if (!file.exists()) {
            System.err.println("File not exists: " + file);
            return null;
        }
        LinkedList<String> usefroms = new LinkedList<String>();
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            docFactory.setValidating(false);
            docFactory.setCoalescing(true);
            Document doc = docFactory.newDocumentBuilder().parse(file);
            NodeList nodeList = doc.getElementsByTagName("interface");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element elem = (Element)nodeList.item(i);
                String kindNodeValue = elem.getAttribute("kind");
                if (!kindNodeValue.equalsIgnoreCase("use")) continue;
                String schemaNodeValue = elem.getAttribute("schema");
                usefroms.add(schemaNodeValue);
            }
        }
        catch (ParserConfigurationException e) {
            System.out.println("PROBLEM: " + e.getMessage());
            e.printStackTrace();
        }
        catch (SAXException sxe) {
            Exception x = sxe;
            if (sxe.getException() != null) {
                x = sxe.getException();
            }
            x.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return usefroms;
    }
}

