/*
 * Decompiled with CFR 0.152.
 */
package jsdai.tools;

import com.lksoft.util.ArgumentsParser;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public final class ModulesCreator {
    public static final String SCRIPT_LOCATION = "utils";

    private ModulesCreator() {
    }

    public static boolean createModule(File scriptDir, String moduleName) {
        Runtime runtime = Runtime.getRuntime();
        String s1 = "WScript.exe mkmodule_mod.wsf /mn:" + moduleName;
        Process process = null;
        try {
            process = runtime.exec(s1, null, scriptDir);
            process.waitFor();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (IOException ioexception) {
            System.out.println("EXCEPTION: " + ioexception);
            System.out.println("Command line is incorrect as parser cannot be found\nat the given location. Exiting program");
            return false;
        }
        return true;
    }

    public static void createModuleArmDescriptions(File scriptDir, String moduleName) {
        String xmlFileName = "../data/modules/" + moduleName + "/arm.xml";
        Runtime runtime = Runtime.getRuntime();
        String s1 = "WScript.exe extractDescriptions_mod.wsf /fn:" + xmlFileName;
        System.out.println(s1);
        Process process = null;
        try {
            process = runtime.exec(s1, null, scriptDir);
            process.waitFor();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (IOException ioexception) {
            System.out.println("EXCEPTION: " + ioexception);
            System.out.println("Command line is incorrect as parser cannot be found\nat the given location. Exiting program");
            System.exit(0);
        }
    }

    private static Object[] parseArgs(String[] args) {
        ArgumentsParser.Value stepmodArg = new ArgumentsParser.Value("-stepmod", true);
        stepmodArg.setValueName("stepmodDir");
        stepmodArg.setDescription("Path to stepmod. Example: c:/workspace/stepmod");
        ArgumentsParser.Value modulesArg = new ArgumentsParser.Value("-module", true);
        modulesArg.setValueName("module");
        modulesArg.setDescription("Name of new module to be created.");
        List<Object> argList = Arrays.asList(stepmodArg, modulesArg);
        if (!ArgumentsParser.parse((String[])args, argList)) {
            System.out.println(ArgumentsParser.getUsage((String)ModulesCreator.class.getName(), argList));
            return null;
        }
        File stepmodDir = new File(stepmodArg.getValue());
        if (!stepmodDir.exists() || !stepmodDir.isDirectory()) {
            System.out.println("Specified stepmod dir does not exists: " + stepmodDir);
            return null;
        }
        String module = modulesArg.getValue();
        return new Object[]{stepmodDir, module};
    }

    public static void main(String[] args) {
        Object[] parsedArgs = ModulesCreator.parseArgs(args);
        if (parsedArgs == null) {
            return;
        }
        File stepmodDir = (File)parsedArgs[0];
        File scriptLoc = new File(stepmodDir, SCRIPT_LOCATION);
        String module = (String)parsedArgs[1];
        if (ModulesCreator.createModule(scriptLoc, module)) {
            ModulesCreator.createModuleArmDescriptions(scriptLoc, module);
        }
    }
}

