/*
 * Decompiled with CFR 0.152.
 */
package jsdai.tools;

import com.lksoft.util.ArgumentsParser;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilderFactory;
import jsdai.tools.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ModulesLister {
    private ModulesLister() {
    }

    public static Set getModuleNames(File repoIndexFile, String theProject) {
        Document repoIndex;
        if (!repoIndexFile.exists()) {
            System.err.println("File not found: " + repoIndexFile);
            return Collections.EMPTY_SET;
        }
        try {
            repoIndex = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(repoIndexFile);
        }
        catch (Exception e) {
            System.err.println("Unable to parse: " + repoIndexFile);
            return Collections.EMPTY_SET;
        }
        Element root = repoIndex.getDocumentElement();
        Element modules = Utils.getSubElement(root, "modules");
        if (modules == null) {
            System.err.println("Unable to find modules in: " + repoIndexFile);
            return Collections.EMPTY_SET;
        }
        HashSet<String> result = new HashSet<String>();
        NodeList children = modules.getChildNodes();
        int n = children.getLength();
        for (int i = 0; i < n; ++i) {
            String project;
            Element elem;
            Node child = children.item(i);
            if (!(child instanceof Element) || !(elem = (Element)child).getTagName().equalsIgnoreCase("module") || !(project = elem.getAttribute("project")).equalsIgnoreCase(theProject)) continue;
            result.add(elem.getAttribute("name").toLowerCase());
        }
        return result;
    }

    private static Object[] parseArgs(String[] args) {
        ArgumentsParser.Value repArg = new ArgumentsParser.Value("-index", true);
        repArg.setValueName("repositoryIndex");
        repArg.setDescription("Path to repository index. Example: c:/workspace/stepmod/repository_index.xml");
        ArgumentsParser.Value projectArg = new ArgumentsParser.Value("-project", true);
        projectArg.setValueName("project");
        projectArg.setDescription("Name of project that owns modules to be included.");
        ArgumentsParser.Value sufixArg = new ArgumentsParser.Value("-sufix", false);
        sufixArg.setValueName("sufix1[;sufix2[;...]]");
        sufixArg.setDescription("List of semicolumn seperated sufixes to be appended to module names.");
        List<Object> argList = Arrays.asList(repArg, projectArg, sufixArg);
        if (!ArgumentsParser.parse((String[])args, argList)) {
            System.out.println(ArgumentsParser.getUsage((String)ModulesLister.class.getName(), argList));
            return null;
        }
        File repFile = new File(repArg.getValue());
        if (!repFile.exists() || !repFile.isFile()) {
            System.out.println("Specified repository index does not exists: " + repFile);
            return null;
        }
        String project = projectArg.getValue();
        LinkedList<String> sufixes = new LinkedList<String>();
        if (sufixArg.getIsSet()) {
            String s = sufixArg.getValue();
            StringTokenizer st = new StringTokenizer(s, ";");
            while (st.hasMoreTokens()) {
                sufixes.add(st.nextToken());
            }
        }
        return new Object[]{repFile, project, sufixes};
    }

    public static void main(String[] args) {
        Object[] parsedArgs = ModulesLister.parseArgs(args);
        if (parsedArgs == null) {
            return;
        }
        File repIndex = (File)parsedArgs[0];
        String project = (String)parsedArgs[1];
        List sufixes = (List)parsedArgs[2];
        boolean appendSufixes = sufixes.size() > 0;
        TreeSet modules = new TreeSet(ModulesLister.getModuleNames(repIndex, project));
        for (String module : modules) {
            if (appendSufixes) {
                for (String sufix : sufixes) {
                    System.out.println(module + sufix);
                }
                continue;
            }
            System.out.println(module);
        }
    }
}

