/*
 * Decompiled with CFR 0.152.
 */
package jsdai.tools;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import jsdai.lang.ASdaiRepository;
import jsdai.lang.SdaiContext;
import jsdai.lang.SdaiException;
import jsdai.lang.SdaiIterator;
import jsdai.lang.SdaiRepository;
import jsdai.lang.SdaiSession;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

final class Utils {
    public static final String EXPRESS_XML_DOCTYPE_VALUE = "../../../dtd/express.dtd";

    private Utils() {
    }

    public static SdaiRepository getRepo(String name) throws SdaiException {
        SdaiSession session = SdaiSession.openSession();
        session.setSdaiContext(new SdaiContext());
        session.startTransactionReadWriteAccess();
        ASdaiRepository arep = session.getKnownServers();
        SdaiRepository repository = null;
        SdaiIterator si = arep.createIterator();
        while (si.next()) {
            SdaiRepository tempRepository = arep.getCurrentMember(si);
            if (!tempRepository.getName().equals(name)) continue;
            repository = tempRepository;
            break;
        }
        if (repository == null) {
            System.out.println("Repository " + name + " not found. Unable to proceed.");
            return null;
        }
        if (!repository.isActive()) {
            repository.openRepository();
        }
        return repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List readListFile(File schemasFile) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(schemasFile));
        LinkedList<String> schemas = new LinkedList<String>();
        try {
            String s;
            while ((s = reader.readLine()) != null) {
                schemas.add(s);
            }
        }
        finally {
            reader.close();
        }
        return schemas;
    }

    public static String read(File file) throws IOException {
        String s;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(baos);
        BufferedReader reader = new BufferedReader(new FileReader(file));
        while ((s = reader.readLine()) != null) {
            writer.println(s);
        }
        reader.close();
        writer.close();
        return baos.toString();
    }

    public static Element getSubElement(Element parent, String tagName) {
        NodeList children = parent.getChildNodes();
        int n = children.getLength();
        for (int i = 0; i < n; ++i) {
            Element elem;
            Node child = children.item(i);
            if (!(child instanceof Element) || !(elem = (Element)child).getTagName().equalsIgnoreCase(tagName)) continue;
            return elem;
        }
        return null;
    }

    public static void saveToFile(String fileName, Document what, String dtd) throws IOException, TransformerException {
        TransformerFactory fact = TransformerFactory.newInstance();
        Transformer t = fact.newTransformer();
        t.setOutputProperty("indent", "yes");
        if (dtd != null) {
            t.setOutputProperty("doctype-system", dtd);
        }
        t.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "3");
        t.transform(new DOMSource(what), new StreamResult(new File(fileName)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map readMapFile(File file) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        HashMap<String, String> res = new HashMap<String, String>();
        try {
            String s;
            while ((s = reader.readLine()) != null) {
                if (s.startsWith("#")) continue;
                StringTokenizer st = new StringTokenizer(s, ",");
                if (st.countTokens() == 2) {
                    String key = st.nextToken();
                    String value = st.nextToken();
                    if (res.containsKey(key)) {
                        System.err.println("Dublicated key: " + key);
                    }
                    res.put(key, value);
                    continue;
                }
                System.err.println("Invalid line format: " + s);
            }
        }
        finally {
            reader.close();
        }
        return res;
    }

    public static Set toLowerCase(Set set) {
        HashSet<String> newSet = new HashSet<String>();
        for (String s : set) {
            newSet.add(s.toLowerCase());
        }
        return newSet;
    }

    public static Properties loadProperties(String file) throws IOException {
        Properties props = new Properties();
        FileInputStream input = new FileInputStream(file);
        props.load(input);
        input.close();
        return props;
    }
}

